;=============RECEIVER VOTER (pic16f877)===========

;-----------Einstellungen beim programmieren mit picstart plus
 			list	p=16f877
			__config	0x3f71		;osc: XT, watchdog timer: off, power up timer: on, 
									;code protect: off, brown out detect: on, low voltage program: disabled,
									;data EE read protect: off, flash program write: enabled 

			errorlevel	-302
			errorlevel	-306

;-----------Ersetzungen--------------
#define		squelch1_led			portc, 0
#define		squelch2_led			portc, 1
#define		squelch3_led			portc, 2
#define		squelch4_led			portc, 3
#define		squelch5_led			portc, 4
#define		squelch6_led			portc, 5
#define		squelch7_led			portc, 6
#define		squelch8_led			portc, 7

#define		ptt_positiv				portd, 0
#define		ptt_negativ				porta, 4	;fr geschwindigkeitstests im normalablauf an 2 stellen im programm deaktiviert
#define		lcd_e					portd, 3
#define		lcd_rs					portd, 1
#define		lcd_rw					portd, 2

#define		daten_taster_down		portb, 3
#define		menue_taster			portb, 4
#define		daten_taster_up			portb, 2

#define		cd4051_a				ausgabe, 5
#define		cd4051_b				ausgabe, 6
#define		cd4051_c				ausgabe, 7



;-------Bit Definitionen

c		equ	0
z		equ	2
rp0		equ	5
rp1		equ	6
eepgd	equ	7
rd		equ	0
wren	equ	2
wr		equ	1	
f		equ	1
d		equ	0
w		equ	0


;-----------sfr register adressen
;-------------bank0
tmr0		equ 0x01
status		equ	0x03
porta		equ	0x05
portb		equ	0x06
portc		equ	0x07
portd		equ	0x08
porte		equ	0x09
pclath		equ	0x0a
intcon		equ	0x0b
adresh		equ	0x1e
adcon0		equ	0x1f
;-------------bank1
option_reg	equ	0x81
trisa		equ	0x85
trisb		equ	0x86
trisc		equ	0x87
trisd		equ	0x88
trise		equ	0x89
adresl		equ	0x9e
adcon1		equ	0x9f
;------------bank2
eedata		equ	0x10c
eeadr		equ 0x10d	
;-------------bank3--------
eedata		equ	0x10c
eeadr		equ	0x10d
;-------------bank4--------
eecon1		equ	0x18c
eecon2		equ	0x18d

;-----------allgemeine register adressen IN bank0	
				
rx1			equ	0x20				;AD Werte der Rauschspannung der RX
rx2			equ	0x21
rx3			equ	0x22
rx4			equ	0x23
rx5			equ	0x24
rx6			equ	0x25
rx7			equ	0x26
rx8			equ	0x27
rx_alt			equ	0x28	;bestes ad ergebnis der vorhergehenden messungen
rx_test			equ	0x29			;zwischenregister fr hystereseberechnungen
squelch_rx1		equ	0x2a		;enthlt Werte ber die Rauschsperrenansprechschwelle
squelch_rx2		equ	0x2b		;werden vom User gesetzt
squelch_rx3		equ	0x2c
squelch_rx4		equ	0x2d
squelch_rx5		equ	0x2e
squelch_rx6		equ	0x2f
squelch_rx7		equ	0x30
squelch_rx8		equ	0x31
squelch_reg		equ	0x32		;Hilfsreg zur Bestimmung ob ein COR Signal auszugeben ist
hysterese_rx1		equ	0x33	;Hysteresewerte obere Grenze fr die einzelnen RX Werte, werden vom user gesetzt
hysterese_rx2		equ	0x34	;mit den Hysteresen wird ein Fensterdiskriminator nachgebildet
hysterese_rx3		equ	0x35				
hysterese_rx4		equ	0x36	
hysterese_rx5		equ	0x37
hysterese_rx6		equ	0x38
hysterese_rx7		equ	0x39
hysterese_rx8		equ	0x3a
hystereselow_rx1	equ	0x3b	;Hysteresewerte untere Grenze fr die einzelnen RX Werte, werden vom user gesetzt
hystereselow_rx2	equ	0x3c
hystereselow_rx3	equ	0x3d
hystereselow_rx4	equ	0x3e
hystereselow_rx5	equ	0x3f
hystereselow_rx6	equ	0x40
hystereselow_rx7	equ	0x41
hystereselow_rx8	equ	0x42
rx_aus_ein		equ	0x43	;register ob rx ausgewertet werden soll oder nicht	
count			equ	0x44	;register fr delay loops
ausgabe			equ	0x45	;register rum manipulieren der Ausgabe an den cd4051
adresse			equ	0x46	;adresse des eeprombytes beim lesen und beschreiben
timer1			equ	0x47	;register fr pausen
timer2			equ	0x48	;register fr pausen
menue_register		equ	0x49	;hilfsregister im menue modus
daten_register		equ	0x4a	;hilfsregister im daten modus
binaer			equ	0x4b	;register fr hex nach ascii wandlung
ones			equ	0x4c	;register fr hex nach ascii wandlung
tens			equ	0x4d	;register fr hex nach ascii wandlung
huns			equ	0x4e	;register fr hex nach ascii wandlung
count1			equ	0x4f	;register fr hex nach ascii wandlung
lcd_read		equ	0x50	;lcd register
rs_value		equ	0x51	;lcd register
lcd_char		equ	0x52	;lcd register
timer3			equ	0x53	;lcd register	
drehzaehler		equ	0x54	;hilfsregister fr drehgeber
d_neu			equ	0x55	;hilfsregister fr drehgeber
d_alt			equ	0x56	;hilfsregister fr drehgeber
rauf_runter		equ	0x57	;hilfsregister fr drehgeber
grutimer		equ	0x58	;timer bei power up zur anzeige der begrung
upper_limit		equ	0x59	;grenzen bei der hystereseberechnung
lower_limit		equ	0x5a
greater_than		equ	0x5b
literal_zahl		equ	0x5c
start_up		equ	0x5d
fast_voting		equ	0x5e
verzoegerung		equ	0x5f	;einschaltverzoegerung der ptt
runterzaehlen		equ	0x60
flatterpause		equ	0x61				
fast_voten_zaehler	equ	0x62
ptt_tail			equ	0x63	;register aus dem heraus (im Menu) entschieden wird welche ptt_tail anzuwenden ist
;diese register knnen aus allen bnken direkt anbgesprochen werden


auswerteregister	equ	0x70		;w_temp, status_temp, pclath_temp mssen in 0x70 bis 0x7f
;status_temp		equ	0x71		;liegen, da diese register von allen bnken aus ohne umschalterei
;pclath_temp		equ	0x72		;addressierbar sind


;---------------Register in Bank1
schieberegister1	equ	0xa0
schieberegister2	equ	0xa1
schieberegister3	equ	0xa2
schieberegister4	equ	0xa3
schieberegister5	equ	0xa4
schieberegister6	equ	0xa5
schieberegister7	equ	0xa6
schieberegister8	equ	0xa7
schieberegister9	equ	0xa8
schieberegister10	equ	0xa9
schieberegister11	equ	0xaa
schieberegister12	equ	0xab
schieberegister13	equ	0xac
schieberegister14	equ	0xad
schieberegister15	equ	0xae
schieberegister16	equ	0xaf
schieberegister17	equ	0xb0
schieberegister18	equ	0xb1
schieberegister19	equ	0xb2
schieberegister20	equ	0xb3
schieberegister21	equ	0xb4
schieberegister22	equ	0xb5
schieberegister23	equ	0xb6
schieberegister24	equ	0xb7
schieberegister25	equ	0xb8
schieberegister26	equ	0xb9
schieberegister27	equ	0xba
schieberegister28	equ	0xbb
schieberegister29	equ	0xbc
schieberegister30	equ	0xbd
schieberegister31	equ	0xbe
schieberegister32	equ	0xbf




hilfsregister1		equ	0xc0
hilfsregister2		equ	0xc1
hilfsregister3		equ	0xc2
hilfsregister4		equ	0xc3
hilfsregister5		equ	0xc4
hilfsregister6		equ	0xc5
hilfsregister7		equ	0xc6
hilfsregister8		equ	0xc7
hilfsregister9		equ	0xc8
hilfsregister10		equ	0xc9
hilfsregister11		equ	0xca
hilfsregister12		equ	0xcb
hilfsregister13		equ	0xcc
hilfsregister14		equ	0xcd
hilfsregister15		equ	0xce
hilfsregister16		equ	0xcf
hilfsregister17		equ	0xd0
hilfsregister18		equ	0xd1
hilfsregister19		equ	0xd2
hilfsregister20		equ	0xd3
hilfsregister21		equ	0xd4
hilfsregister22		equ	0xd5
hilfsregister23		equ	0xd6
hilfsregister24		equ	0xd7
hilfsregister25		equ	0xd8
hilfsregister26		equ	0xd9
hilfsregister27		equ	0xda
hilfsregister28		equ	0xdb
hilfsregister29		equ	0xdc
hilfsregister30		equ	0xdd
hilfsregister31		equ	0xde
hilfsregister32		equ	0xdf


schiebezaehler		equ	0xe0				





;----------------Makros
bank0	macro
		bcf	status, 5	
		bcf	status, 6
		endm		

bank1	macro
		bsf	status, 5	
		bcf	status, 6
		endm		
	
bank2	macro
		bcf	status, 5	
		bsf	status, 6	
		endm		

bank3	macro
		bsf	status, 5	
		bsf	status, 6
		endm		

page0	macro
		bcf	pclath, 4	
		bcf	pclath, 3
		endm		

page1	macro
		bcf	pclath, 4	
		bsf	pclath, 3
		endm		

page2	macro
		bsf	pclath, 4	
		bcf	pclath, 3
		endm		

page3	macro
		bsf	pclath, 4	
		bsf	pclath, 3
		endm		
;----------ende makros

;-------------eeprom programmieren beim brennen mit picstart plus
		org	0x2100

;---EEPROM Adressen	0x00  0x01  0x02  0x03 	0x04	0x06	0x07	
	de	d'10', d'10', d'10', d'10', d'10', d'10', d'10', d'10'	;squelch_rx1 bis squelch_rx8

;---EEPROM Adressen	0x08  0x09  0x0a  0x0b   0x0c   0x0d  0x0e   0x0f  
	de	d'0', d'0', d'0', d'0', d'0', d'0', d'0', d'0'	;upper limit:hysterese_rx1 bis hysterese_rx8

;---EEPROM Adressen	0x10  
	de	b'11111111'		;rx ein oder ausschaltern (high: eingeschaltet; low:ausgeschaltet)

;---EEPROM Adressen	0x11  0x12  0x13  0x14   0x15   0x16  0x17   0x18  
	de	d'0', d'0', d'0', d'0', d'0', d'0', d'0', d'0'	;lower limit: hystereselow_rx1 bis hystereselow_rx8

;---EEPROM Adressen	0x19   
	de	b'00000000'		;fast voting register

;---EEPROM Adressen	0x1a   
	de	d'0'		;Einschaltverzgerung PTT: 0 Millisekunden

;---EEPROM Adressen	0x1b   
	de	d'0'		;PTT Tail (Flatterautomatik :off)



				org	0x000
				goto	start
;				org	0x004
;				goto	start

start			;init bei power up und reset 

				clrf		intcon
				clrf  		porta
				clrf 		portb
				clrf 		portc
				clrf 		portd
				clrf 		porte
				bank1
				movlw		b'11101111'		
				movwf		trisa			;porta analoge eingnge bis auf porta4: output
				movlw		b'00001111'	;!!!ACHTUNG: bit 7-4- sind fr portc reserviert!!!!	
				movwf		trise			;porte analoge eingnge	
				movlw		b'00000000'		;portc ausgnge
				movwf		trisc
				movlw		b'00000000'		;portd ausgnge
				movwf		trisd
				movlw		b'00011111'		;portb eingnge (bit 4 - 0); bit 7 -5 ausgnge
				movwf		trisb
				bcf			option_reg, 7	;pullups am port b einschalten
				bank0
				movlw		d'255'
				movwf		rx_alt			;rx_alt muss beim initialisieren auf ganz schlechtes signal gesetzt werden,
											;damit die hystereseberechnung beim 1. durchgang funktioniert.
				bcf			ptt_positiv		;lsche output port fr positive cor logik; bei power up 
				bsf			ptt_negativ		;setze output port fr negative cor logik; bei power up
				
				movlw	d'5'				;zhler fr flatterautomatik, bei fast voten
				movwf	fast_voten_zaehler	;bei fast voten wird nur bei jedem 5 durchgang die flatterautomatik
											;bewertet

				;lcd initialisieren
				
				call		init_lcd
				
				;page2				
				;call		eeprom_auslesen
				;page0
				
				;sind bei power up beide datentaster gleichzeitig gedrckt					
				;wenn ja: eeprom komplett lschen (reset)
				;wenn nein: normaler betrieb
	
				btfsc	daten_taster_up
				goto	testbetrieb		;nicht gedrckt
				btfsc	daten_taster_down
				goto	testbetrieb		;auch nicht gedrckt
;								beide sind gedrckt

				page3
				call	ausgabe_reset_page3
				page0
				movlw	d'0'
				movwf	squelch_rx1	
				movwf	squelch_rx2	
				movwf	squelch_rx3	
				movwf	squelch_rx4	
				movwf	squelch_rx5	
				movwf	squelch_rx6	
				movwf	squelch_rx7	
				movwf	squelch_rx8	

				movwf	hysterese_rx1
				movwf	hysterese_rx2
				movwf	hysterese_rx3
				movwf	hysterese_rx4
				movwf	hysterese_rx5
				movwf	hysterese_rx6
				movwf	hysterese_rx7
				movwf	hysterese_rx8

				movwf	hystereselow_rx1
				movwf	hystereselow_rx2
				movwf	hystereselow_rx3
				movwf	hystereselow_rx4
				movwf	hystereselow_rx5
				movwf	hystereselow_rx6
				movwf	hystereselow_rx7
				movwf	hystereselow_rx8

				movwf	fast_voting
	
				movwf	verzoegerung
	
				movwf	ptt_tail

				movlw	b'11111111'
				movwf	rx_aus_ein
	
				page2
				call		eeprom_beschreiben 
				page0
			



				btfss		daten_taster_up	;warten bis der Taster wieder losgelassen wurde	 				
				goto		$-1				;er ist noch gedrckt
				call		wait_8ms		; er ist losgelassen, entprellen
				btfss		daten_taster_up	;ist erwirklich losgelassen	
				goto		$-4				;nein


				btfss		daten_taster_down	;warten bis der Taster wieder losgelassen wurde	 				
				goto		$-1				;er ist noch gedrckt
				call		wait_8ms		; er ist losgelassen, entprellen
				btfss		daten_taster_down	;ist erwirklich losgelassen	
				goto		$-4				;nein



				

				;testbetrieb
				
testbetrieb			page2				
				call		eeprom_auslesen
				page0
				

				btfsc	menue_taster		;gedrueckt
				goto	packamus			;nein
				call	wait_8ms			;ja
				btfsc	menue_taster		;wirklich gedrueckt
				goto	packamus			;doch nicht
				bsf		start_up, 0				;doch gedrueckt
				clrf	fast_voting			;kein fast_voting
				btfss		menue_taster	;warten bis der Taster wieder losgelassen wurde	 				
				goto		$-1				;er ist noch gedrckt
				call		wait_8ms		; er ist losgelassen, entprellen
				btfss		menue_taster	;ist erwirklich losgelassen	
				goto		$-4				;nein


				;datenleitungen zum 4051 lschen
				;signale mssen invertiert sein, weil extern mit Transistoren nochmals invertiert wird
packamus		movf		portb, 0
				movwf		ausgabe		
				bsf			cd4051_a		;datenleitungen liegen jetzt am 4051 auf low  
				bsf			cd4051_b
				bsf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
								

				;begrung ausgeben
				movlw		d'30'
				movwf		grutimer
				call		lcd_gru
				call		wait_32ms
				decfsz		grutimer, 1
				goto		$-2
				


				;fast voting?
				btfss		fast_voting, 0
				goto		$+2					;nein
				call		lcd_normalbetrieb	;ja
				

				;drehgeber initialisieren 
				movf		portb, 0	;Initialisierung vom Drehgeber
				andlw		b'00000011'
				movwf		d_neu
				movwf		d_alt
				movlw		0x02	;Drehgeber erzeugt pro Rastung 2 Impulse, die werden jeweils ausgemerzt
				movwf		drehzaehler
		
				;--------hilfsregister auf 0 setzen
				clrf		daten_register
				clrf		menue_register



;Dauernde Schleife mit Tastaturabfragen. die Messungen, Auswertumgen und Ausgaben erfolgen zyklisch
;im fast mode dauert ein schleifendurchgang ca. 2200s: d.h.es wird ca. 450 mal pro sekunde gevotet
;im anzeigemode dauert ein schleifendurchgang ca. 11000s: d.h. es wird ca. 90 mal pro sekunde gevotet
schleife			;	call		wait_8ms		;ausbremsen der schleife, damit nicht zu oft ad gewandelt wird
			
;------nur fr geschwindigkeitstest
;				btfss		ptt_negativ
;				goto		testptteinschalten
;				goto		testpttausschalten

;testptteinschalten		bsf	ptt_negativ
;						goto	$+2

;testpttausschalten		bcf	ptt_negativ


;------ende nur fr geschwindigkeitstest

				page1
				call		wandlung				;dauert ca. 1050 s
				page0
				
				btfss		fast_voting, 0
				goto		$+2					;normales voting mit lcd anzeige
				goto		dagehtsweiter		;fast voting mit lcd anzeige "fast voting"



				btfss		start_up, 0		;besondere anzeige fr testzwecke einschalten
				goto		normale_anzeige			;nein
				goto		besondere_anzeige		;ja
normale_anzeige	page3
				call	spannung_lcd			;dauert ca. 10000s mit cursor home und clear display	
				page0							;hngt auch vom display ab
				goto	dagehtsweiter	
besondere_anzeige	page3
				call	spannung_lcd_test		;dauert ca. 10000s
				page0

				
dagehtsweiter	btfsc		menue_taster	;ist der taster gedrckt
				goto		schleife		;nein,kein menuebetrieb
				call		wait_8ms		;ja 
				btfsc		menue_taster	;ist der taster wirklich gedrckt
				goto		schleife		;war doch nicht gedrckt
				;bsf			menue_register, 0	;er ist wirklich gedrckt; vermerken, dass er gedrckt war
				call		menue_lcd			;er ist wirklich gedrckt;Ausgabe an lcd dass menuebetrieb ist
				btfss		menue_taster	;warten bis der Taster wieder losgelassen wurde	 				
				goto		$-1				;er ist noch gedrckt
				call		wait_8ms		; er ist losgelassen, entprellen
				btfss		menue_taster	;ist erwirklich losgelassen	
				goto		$-4				;nein
				clrf		daten_register
				
menue_schleife			;call		menue_taster_pruefen
				page1
				call		wandlung
				page0
				btfsc		menue_taster		;menue Taster gedrckt?
				goto		daten_taster_up_gedrueckt							;nein
				call		wait_8ms			;ja, entprellen
				btfsc		menue_taster		;menue taster gedrckt?
				goto		daten_taster_up_gedrueckt			;nein
				
				goto		menue_abbruch		;ja
				
daten_taster_up_gedrueckt			btfsc		daten_taster_up
				goto		daten_taster_down_gedrueckt
				call		wait_8ms
				btfsc		daten_taster_up
				goto		daten_taster_down_gedrueckt
				incf		daten_register, 1
				movlw		d'36'
				subwf		daten_register, 0
				btfss		status, z
				goto		loslassen_up_pruefen
				movlw		d'1'
				movwf		daten_register
				
loslassen_up_pruefen			btfss		daten_taster_up	;warten bis der Taster wieder losgelassen wurde	 				
				goto		$-1				;er ist noch gedrckt
				call		wait_8ms		; er ist losgelassen, entprellen
				btfss		daten_taster_up	;ist erwirklich losgelassen	
				goto		$-4				;nein



daten_taster_down_gedrueckt			btfsc		daten_taster_down
				goto		wurde_gedreht
				call		wait_8ms
				btfsc		daten_taster_down
				goto		wurde_gedreht
				

				
				decf		daten_register, 1
				movf		daten_register, 0
				sublw		d'0'
				btfss		status, z		
				goto		$+3
				movlw		d'35'
				movwf		daten_register
				
				movlw		d'35'
				movwf		literal_zahl		
				movf		daten_register, 0
				subwf		literal_zahl, 0		
				btfss		status, c
				goto		$+2
				goto		loslassen_down_pruefen		
				movlw		d'35'
				movwf		daten_register
	
loslassen_down_pruefen			btfss		daten_taster_down	;warten bis der Taster wieder losgelassen wurde	 				
				goto		$-1				;er ist noch gedrckt
				call		wait_8ms		; er ist losgelassen, entprellen
				btfss		daten_taster_down	;ist erwirklich losgelassen	
				goto		$-4				;nein



													;tests mit ausgabe in den untermenues, dort auch warten bis der taster
wurde_gedreht			call		dreh
									;wieder losgleassen ist (als subroutine)
				;---test in welchem untermenue wir uns gerade befinden
				
				movlw		d'1'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx1_aendern
			
				movlw		d'2'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx2_aendern
			
				movlw		d'3'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx3_aendern
			
				movlw		d'4'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx4_aendern
			
				movlw		d'5'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx5_aendern
			
				movlw		d'6'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx6_aendern
			
				movlw		d'7'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx7_aendern
			
				movlw		d'8'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		sq_rx8_aendern
			
				movlw		d'9'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx1_aendern

				movlw		d'10'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx2_aendern

				movlw		d'11'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx3_aendern
				

				movlw		d'12'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx4_aendern
				

				movlw		d'13'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx5_aendern
				
				movlw		d'14'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx6_aendern
				
				movlw		d'15'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx7_aendern
				
				movlw		d'16'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx8_aendern
								
				movlw		d'17'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx1LL_aendern

				movlw		d'18'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx2LL_aendern

				movlw		d'19'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx3LL_aendern
				

				movlw		d'20'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx4LL_aendern
				

				movlw		d'21'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx5LL_aendern
				
				movlw		d'22'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx6LL_aendern
				
				movlw		d'23'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx7LL_aendern
				
				movlw		d'24'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		hys_rx8LL_aendern
				

				movlw		d'25'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx1_aendern
				
				movlw		d'26'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx2_aendern
				
				movlw		d'27'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx3_aendern
				
				movlw		d'28'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx4_aendern
				
				movlw		d'29'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx5_aendern
				
				movlw		d'30'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx6_aendern
				
				movlw		d'31'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx7_aendern
				
				movlw		d'32'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		rx_aus_ein_rx8_aendern
				
				movlw		d'33'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		fast_voting_aendern
				
				movlw		d'34'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		ptt_verzoegerung_aendern
				
				movlw		d'35'
				subwf		daten_register, 0	
				btfss		status, z
				goto		$+2
				call		ptt_tail_aendern
				
				
				page1
				call		wandlung
				page0
				goto		menue_schleife		;im daten_register ist irgendwas faul, zurck
				


sq_rx1_aendern	
				movf	squelch_rx1, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx1			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx1, 1		;nach links
				goto	$+2
				incf	squelch_rx1, 1
				movf	squelch_rx1, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx1			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return	;goto	menue_schleife				


sq_rx2_aendern	movf	squelch_rx2, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx2			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx2, 1		;nach links
				goto	$+2
				incf	squelch_rx2, 1
				movf	squelch_rx2, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx2			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

sq_rx3_aendern	movf	squelch_rx3, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx3			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx3, 1		;nach links
				goto	$+2
				incf	squelch_rx3, 1
				movf	squelch_rx3, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx3			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

sq_rx4_aendern	movf	squelch_rx4, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx4			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx4, 1		;nach links
				goto	$+2
				incf	squelch_rx4, 1
				movf	squelch_rx4, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx4			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

sq_rx5_aendern	movf	squelch_rx5, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx5			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx5, 1		;nach links
				goto	$+2
				incf	squelch_rx5, 1
				movf	squelch_rx5, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx5			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

sq_rx6_aendern	movf	squelch_rx6, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx6			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx6, 1		;nach links
				goto	$+2
				incf	squelch_rx6, 1
				movf	squelch_rx6, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx6			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

sq_rx7_aendern	movf	squelch_rx7, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx7			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx7, 1		;nach links
				goto	$+2
				incf	squelch_rx7, 1
				movf	squelch_rx7, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx7			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

sq_rx8_aendern	movf	squelch_rx8, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_rx8			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	squelch_rx8, 1		;nach links
				goto	$+2
				incf	squelch_rx8, 1
				movf	squelch_rx8, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_rx8			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx1_aendern	
				movf	hysterese_rx1, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx1			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx1, 1		;nach links
				goto	$+2
				incf	hysterese_rx1, 1
				movf	hysterese_rx1, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx1			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx2_aendern	
				movf	hysterese_rx2, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx2			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx2, 1		;nach links
				goto	$+2
				incf	hysterese_rx2, 1
				movf	hysterese_rx2, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx2			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx3_aendern	
				movf	hysterese_rx3, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx3			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx3, 1		;nach links
				goto	$+2
				incf	hysterese_rx3, 1
				movf	hysterese_rx3, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx3			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				
hys_rx4_aendern	
				movf	hysterese_rx4, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx4			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx4, 1		;nach links
				goto	$+2
				incf	hysterese_rx4, 1
				movf	hysterese_rx4, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx4			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				
hys_rx5_aendern	
				movf	hysterese_rx5, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx5			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx5, 1		;nach links
				goto	$+2
				incf	hysterese_rx5, 1
				movf	hysterese_rx5, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx5			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				
hys_rx6_aendern	
				movf	hysterese_rx6, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx6			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx6, 1		;nach links
				goto	$+2
				incf	hysterese_rx6, 1
				movf	hysterese_rx6, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx6			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;	goto	menue_schleife				
hys_rx7_aendern	
				movf	hysterese_rx7, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx7			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx7, 1		;nach links
				goto	$+2
				incf	hysterese_rx7, 1
				movf	hysterese_rx7, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx7			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				
hys_rx8_aendern	
				movf	hysterese_rx8, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hys_rx8			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				;call	warte_loslassen	
				;call	dreh
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hysterese_rx8, 1		;nach links
				goto	$+2
				incf	hysterese_rx8, 1
				movf	hysterese_rx8, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hys_rx8			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx1LL_aendern	
				movf	hystereselow_rx1, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx1			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx1, 1		;nach links
				goto	$+2
				incf	hystereselow_rx1, 1
				movf	hystereselow_rx1, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx1			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx2LL_aendern	
				movf	hystereselow_rx2, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx2			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx2, 1		;nach links
				goto	$+2
				incf	hystereselow_rx2, 1
				movf	hystereselow_rx2, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx2			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx3LL_aendern	
				movf	hystereselow_rx3, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx3			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx3, 1		;nach links
				goto	$+2
				incf	hystereselow_rx3, 1
				movf	hystereselow_rx3, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx3			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx4LL_aendern	
				movf	hystereselow_rx4, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx4			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx4, 1		;nach links
				goto	$+2
				incf	hystereselow_rx4, 1
				movf	hystereselow_rx4, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx4			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx5LL_aendern	
				movf	hystereselow_rx5, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx5			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx5, 1		;nach links
				goto	$+2
				incf	hystereselow_rx5, 1
				movf	hystereselow_rx5, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx5			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx6LL_aendern	
				movf	hystereselow_rx6, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx6			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx6, 1		;nach links
				goto	$+2
				incf	hystereselow_rx6, 1
				movf	hystereselow_rx6, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx6			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx7LL_aendern	
				movf	hystereselow_rx7, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx7			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx7, 1		;nach links
				goto	$+2
				incf	hystereselow_rx7, 1
				movf	hystereselow_rx7, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx7			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

hys_rx8LL_aendern	
				movf	hystereselow_rx8, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_hyslow_rx8			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	hystereselow_rx8, 1		;nach links
				goto	$+2
				incf	hystereselow_rx8, 1
				movf	hystereselow_rx8, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_hyslow_rx8			;In Zeile 1 Ausgeben: "Squelch RX01:data"
				return		;goto	menue_schleife				

rx_aus_ein_rx1_aendern			call	ausgabe_rx_aus_ein_rx1		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 0		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 0	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 0
				call	ausgabe_rx_aus_ein_rx1			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						

rx_aus_ein_rx2_aendern			call	ausgabe_rx_aus_ein_rx2		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 1		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 1	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 1
				call	ausgabe_rx_aus_ein_rx2			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						

rx_aus_ein_rx3_aendern			call	ausgabe_rx_aus_ein_rx3		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 2		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 2	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 2
				call	ausgabe_rx_aus_ein_rx3			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						

rx_aus_ein_rx4_aendern			call	ausgabe_rx_aus_ein_rx4		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 3		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 3	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 3
				call	ausgabe_rx_aus_ein_rx4			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						

rx_aus_ein_rx5_aendern			call	ausgabe_rx_aus_ein_rx5		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 4		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 4	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 4
				call	ausgabe_rx_aus_ein_rx5			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						

rx_aus_ein_rx6_aendern			call	ausgabe_rx_aus_ein_rx6		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 5		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 5	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 5
				call	ausgabe_rx_aus_ein_rx6			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						

rx_aus_ein_rx7_aendern			call	ausgabe_rx_aus_ein_rx7		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 6		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 6	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 6
				call	ausgabe_rx_aus_ein_rx7			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						

rx_aus_ein_rx8_aendern			call	ausgabe_rx_aus_ein_rx8		;In Zeile 1 Ausgeben: "RX01:aus/ein"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	rx_aus_ein, 7		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	rx_aus_ein, 7	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	rx_aus_ein, 7
				call	ausgabe_rx_aus_ein_rx8			;In Zeile 1 Ausgeben: "RX01:aus/ein"
				return						


fast_voting_aendern			call	ausgabe_fast_voting		;In Zeile 1 Ausgeben: "fast voting :on/off"
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return				;nein
						;es wurde gedreht,drehrichtung ist wurscht
				btfss	fast_voting, 0		
				goto	$+3		;bit 0 war gelscht, also setzen
				bcf	fast_voting, 0	;bit 0 gesetzt, also lschen				
				goto	$+2
				bsf	fast_voting, 0
				call	ausgabe_fast_voting			;In Zeile 1 Ausgeben: "fast voting:on/off"
				return						


ptt_verzoegerung_aendern	
				movf	verzoegerung, 0
				movwf	binaer
				call	bin2ascii
				call	ausgabe_ptt_verzoegerung			;Ausgeben: "xxx mS PTT (COR) turn on delay "
				btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	$+3					;nach rechts	
				decf	verzoegerung, 1		;nach links
				goto	$+2
				incf	verzoegerung, 1
				movf	verzoegerung, 0
				movwf	binaer	
				call	bin2ascii			;	
				call	ausgabe_ptt_verzoegerung			;Ausgeben: "xxx mS PTT (COR) turn on delay "
				return		;goto	menue_schleife				



ptt_tail_aendern
				call	ausgabe_ptt_tail_zeile1	;ausgeben in zeile1: PTT (COR) tail
				movlw	0x00
				subwf	ptt_tail, 0
				btfss	status, z		;ptt_tail 0?
				goto	ptt_tail_0_50	;nein
				call	ausgabe_ptt_tail0		;ja
				goto	ptt_tail_weiter

ptt_tail_0_50	movlw	0x01
				subwf	ptt_tail, 0
				btfss	status, z	;ptt_tail 1?
				goto	ptt_tail_0_100	;nein
				call	ausgabe_ptt_tail50		;ja
				goto	ptt_tail_weiter

ptt_tail_0_100	call	ausgabe_ptt_tail100		;weder 0 noch 1, dann wars 2

					
ptt_tail_weiter	btfsc	rauf_runter, 1		;wurde am drehgeber gedreht
				goto	$+2					;ja
				return		;goto	menue_schleife		;nein
				btfsc	rauf_runter, 0		;nach rechts oder links gedreht
				goto	incf_ptt_tail			;nach rechts	
				goto	decf_ptt_tail		;nach links
				
incf_ptt_tail	incf	ptt_tail, 1
				movlw	d'3'
				subwf	ptt_tail, 0
				btfss	status, z	;ist ptt_tail nach erhhung 3?
				goto	$+4		;nein, ptt_tail ist 1 oder 2	
				clrf	ptt_tail		;ja, dann auf null setzen
				call	ausgabe_ptt_tail0
				return
				movlw	d'1'
				subwf	ptt_tail, 0
				btfss	status, z		;ist ptt_tail 1
				goto	$+3					;nein, dann ist er 2
				call	ausgabe_ptt_tail50			;ja
				return						
				call	ausgabe_ptt_tail100
				return

decf_ptt_tail	decf	ptt_tail, 1
				movlw	d'255'	
				subwf	ptt_tail, 0		;ist ptt_tail nach verringerung 255?
				btfss	status, z
				goto	$+5				;nein, dann ist er jetzt 1 oder 0
				movlw	d'2'		;ja, dann war er vorher 0 und wird jetzt zu 2
				movwf	ptt_tail					
				call	ausgabe_ptt_tail100
				return
				movlw	d'1'
				subwf	ptt_tail, 0	;ist ptt tail 0 oder 1
				btfss	status, z
				goto	$+3			;nein, dann ist er 0
				call	ausgabe_ptt_tail50			;ja
				return
				call	ausgabe_ptt_tail0
				return


menue_abbruch	;abbruch des menuemodus (vorher warten, bis der taster losgelassen wurde
						; mit abfrage nach speichern im eeprom
				

				movlw		d'255'
				movwf		rx_alt			;wir erzwingen ein Umschalten
				;movwf		upper_limit
				;movwf		lower_limit		
				page1
				call		wandlung		;weil der rx_alt so schlecht ist
				page0
				page1
				call		wandlung		;zweite wandlung um einen gltigen rx_alt zu erhalten
				page0
				call		menue_ende			;ausgabe an lcd, dass beendet wird
				clrf		daten_register
				clrf		menue_register
				page2
				call		eeprom_beschreiben 
				page0
				btfss		menue_taster	;warten bis der Taster wieder losgelassen wurde	 				
				goto		$-1				;er ist noch gedrckt
				call		wait_8ms		; er ist losgelassen, entprellen
				btfss		menue_taster	;ist erwirklich losgelassen	
				goto		$-4				;nein
				
				btfss		fast_voting, 0
				goto 		schleife
				call		lcd_normalbetrieb
				goto		schleife	

		
;===================SUBROUTINEN in der Hauptschleife

;--------------------------------Drehgeber abfragen
;=========================================================================
dreh			clrf		rauf_runter
				movf		portb, 0
				andlw		b'00000011'
				movwf		d_neu
				xorwf		d_alt, 0
				btfsc		status, z
				return		;keine Bewegung am Drehgeber, bei rcksprung ist bit 1 von rauf_runter gelscht (keine drehung erfolgt)
	
				bcf			status, c
				rlf			d_alt, 1
				movf		d_neu, 0
				xorwf		d_alt, 1
				btfss		d_alt, 1
				goto		dreh1		;Drehgeber gedreht nach links
;-------------erhhen der qrg			;Drehgeber gedreht nach rechts
				decfsz		drehzaehler, 1	;pro Rastung 2 Impulse, einer wird ausgemerzt
				goto		dreh3
				bsf			rauf_runter, 0	;bit, dass nach rechts gedreht wurde	
				bsf			rauf_runter, 1	;bit, dass berhaupt gedreht wurde
				goto		dreh2
		
;------------verringern der qrg		
dreh1			decfsz		drehzaehler, 1
				goto		dreh3
				bcf			rauf_runter, 0	;bit, dass nach links gedreht wurde
				bsf			rauf_runter, 1	;bit, dass berhaupt gedreht wurde
				goto		dreh2

;---ausmerzen des einen impulses
dreh3			call		wait_1ms
				movf		d_neu, 0
				movwf		d_alt
				goto		dreh


;------------rcksprung
dreh2			movf		d_neu, 0
				movwf		d_alt
				movlw		0x02
				movwf		drehzaehler
				return

;-------------------------------ENDE: Drehgeber abfragen
;-------------ausgaben an lcd
menue_lcd			page3
					call	menue_lcd_page3
					page0
					return
ausgabe_rx1			page3
					call	ausgabe_rx1_page3
					page0
					return
ausgabe_rx2			page3
					call	ausgabe_rx2_page3
					page0		
					return
ausgabe_rx3			page3
					call	ausgabe_rx3_page3
					page0
					return
ausgabe_rx4			page3
					call	ausgabe_rx4_page3
					page0
					return
ausgabe_rx5			page3
					call	ausgabe_rx5_page3
					page0
					return
ausgabe_rx6			page3
					call	ausgabe_rx6_page3
					page0
					return
ausgabe_rx7			page3
					call	ausgabe_rx7_page3
					page0
					return
ausgabe_rx8			page3
					call	ausgabe_rx8_page3
					page0
					return
ausgabe_hys_rx1		page3
					call	ausgabe_hys_rx1_page3
					page0		
					return
ausgabe_hys_rx2		page3
					call	ausgabe_hys_rx2_page3
					page0		
					return
ausgabe_hys_rx3		page3
					call	ausgabe_hys_rx3_page3
					page0		
					return
ausgabe_hys_rx4		page3
					call	ausgabe_hys_rx4_page3
					page0		
					return
ausgabe_hys_rx5		page3
					call	ausgabe_hys_rx5_page3
					page0		
					return
ausgabe_hys_rx6		page3
					call	ausgabe_hys_rx6_page3
					page0		
					return
ausgabe_hys_rx7		page3
					call	ausgabe_hys_rx7_page3
					page0		
					return
ausgabe_hys_rx8		page3
					call	ausgabe_hys_rx8_page3
					page0		
					return

ausgabe_hyslow_rx1	page3
					call	ausgabe_hyslow_rx1_page3
					page0
					return

ausgabe_hyslow_rx2	page3
					call	ausgabe_hyslow_rx2_page3
					page0
					return

ausgabe_hyslow_rx3	page3
					call	ausgabe_hyslow_rx3_page3
					page0
					return

ausgabe_hyslow_rx4	page3
					call	ausgabe_hyslow_rx4_page3
					page0
					return

ausgabe_hyslow_rx5	page3
					call	ausgabe_hyslow_rx5_page3
					page0
					return

ausgabe_hyslow_rx6	page3
					call	ausgabe_hyslow_rx6_page3
					page0
					return

ausgabe_hyslow_rx7	page3
					call	ausgabe_hyslow_rx7_page3
					page0
					return

ausgabe_hyslow_rx8	page3
					call	ausgabe_hyslow_rx8_page3
					page0
					return


ausgabe_rx_aus_ein_rx1		page3
				call	ausgabe_rx_aus_ein_rx1_page3
				page0
				return

ausgabe_rx_aus_ein_rx2		page3
				call	ausgabe_rx_aus_ein_rx2_page3
				page0
				return

ausgabe_rx_aus_ein_rx3		page3
				call	ausgabe_rx_aus_ein_rx3_page3
				page0
				return

ausgabe_rx_aus_ein_rx4		page3
				call	ausgabe_rx_aus_ein_rx4_page3
				page0
				return

ausgabe_rx_aus_ein_rx5		page3
				call	ausgabe_rx_aus_ein_rx5_page3
				page0
				return

ausgabe_rx_aus_ein_rx6		page3
				call	ausgabe_rx_aus_ein_rx6_page3
				page0
				return

ausgabe_rx_aus_ein_rx7		page3
				call	ausgabe_rx_aus_ein_rx7_page3
				page0
				return

ausgabe_rx_aus_ein_rx8		page3
				call	ausgabe_rx_aus_ein_rx8_page3
				page0
				return

ausgabe_fast_voting		page3
						call	ausgabe_fast_voting_page3
						page0
						return

ausgabe_ptt_verzoegerung	page3
						call	ausgabe_ptt_verzoegerung_page3
						page0
						return

ausgabe_ptt_tail_zeile1	page3
						call	ausgabe_ptt_tail_zeile1_page3
						page0
						return


ausgabe_ptt_tail0		page3
						call	ausgabe_ptt_tail0_page3
						page0
						return


ausgabe_ptt_tail50		page3
						call	ausgabe_ptt_tail50_page3
						page0
						return


ausgabe_ptt_tail100		page3
						call	ausgabe_ptt_tail100_page3
						page0
						return


menue_ende			page3	
					call	menue_ende_page3
					page0
					return

lcd_gru	page3
					call	lcd_gru_page3
					page0
					return

lcd_normalbetrieb	page3
					call	lcd_normalbetrieb_page3
					page0
					return


init_lcd					page3
					call	init_lcd_page3
					page0		
;==================PAUSEN======================
; *****************************************************************************
; *                                                                           *
; * Purpose:  Wait for a specified number of milliseconds.                    *
; *                                                                           *
; *           Entry point wait_128ms:  Wait for 128 msec                      *
; *           Entry point wait_64ms :  Wait for 64 msec                       *
; *           Entry point wait_32ms :  Wait for 32 msec                       *
; *           Entry point wait_16ms :  Wait for 16 msec                       *
; *           Entry point wait_8ms  :  Wait for 8 msec                        *
; *                                                                           *
; *   Input:  None                                                            *
; *                                                                           *
; *  Output:  None                                                            *
; *                                                                           *
; *****************************************************************************
;
wait_128ms  ; ****** Entry point ******    
				movlw	  	0xff              ; Set up outer loop 
				movwf  	 	timer1            ;   counter to 255
				goto   	 	outer_loop        ; Go to wait loops
wait_64ms  ; ****** Entry point ******     
				movlw   	0x80              ; Set up outer loop
				movwf   	timer1            ;   counter to 128
				goto    	outer_loop        ; Go to wait loops
wait_32ms   ; ****** Entry point ******    
				movlw   	0x40              ; Set up outer loop
				movwf   	timer1            ;   counter to 64
				goto    	outer_loop        ; Go to wait loops
wait_16ms   ; ****** Entry point ******    
				movlw   	0x20              ; Set up outer loop
				movwf   	timer1            ;   counter to 32  
				goto    	outer_loop        ; Go to wait loops
wait_8ms   ; ****** Entry point ******     
				movlw   	0x10              ; Set up outer loop
				movwf   	timer1            ;   counter to 16
				goto 		outer_loop	  ; Fall through into wait loops
wait_1ms   ; ****** Entry point ******     
				movlw   	0x02              ; Set up outer loop
				movwf   	timer1            ;   counter to 2
				goto		outer_loop


		
; Wait loops used by other wait routines
;  - 1 microsecond per instruction (with a 4 MHz microprocessor crystal)
;  - 510 instructions per inner loop
;  - (Timer1 * 514) instructions (.514 msec) per outer loop
;  - Round off to .5 ms per outer loop
;
outer_loop                        
				movlw   	0xff              ; Set up inner loop counter
				movwf   	timer2            ;   to 255
inner_loop
				decfsz  	timer2,f          ; Decrement inner loop counter
				goto    	inner_loop        ; If inner loop counter not down to zero, 
					  ;   then go back to inner loop again
				decfsz  	timer1,f          ; Yes, Decrement outer loop counter
				goto  		outer_loop        ; If outer loop counter not down to zero,
					  ;   then go back to outer loop again
				return                    ; Yes, return to caller
;--------------ende pausen
;---------------------8 Bit Binr (HEX) nach ASCII Ergebnis: Hunderter in huns, Zehner in tens, Einer in ones
;---------------------Input: in binaer, call aufruf: bin2ascii
;---------------------Code stammt von piclist
;in: binaer
;out huns. tens, ones

;uses ADD-3 algoerthm
;ca 330 s

bin2ascii			movlw		8
					movwf		count1
					clrf		huns
					clrf		tens
					clrf		ones

BCDADD3

					movlw		5
					subwf		huns, 0
					btfsc		status, c
					call		ADD3HUNS

					movlw		5
					subwf		tens, 0
					btfsc		status, c
					call		ADD3TENS

					movlw		5
					subwf		ones, 0
					btfsc		status, c
					call		ADD3ONES

					decf 		count1, 1
					bcf 		status, c
					rlf 		binaer, 1
					rlf 		ones, 1
					btfsc 		ones,4 ; 
					call 		CARRYONES
					rlf 		tens, 1

					btfsc 		tens,4 ; 
					call 		CARRYTENS
					rlf 		huns,1
					bcf 		status, c

					movf 		count1, 0
					btfss 		status, z
					goto 		BCDADD3


					movf 		huns, 0 ; add ASCII Offset
					addlw 		h'30'
					movwf 		huns

					movf 		tens, 0 ; add ASCII Offset
					addlw 		h'30'
					movwf		tens
	
					movf	 	ones, 0 ; add ASCII Offset
					addlw 		h'30'
					movwf 		ones

					return

ADD3HUNS

					movlw 		3
					addwf		huns,1

					return

ADD3TENS

					movlw 		3
					addwf 		tens,1
	
					return

ADD3ONES

					movlw	 	3
					addwf 		ones,1

					return

CARRYONES
					bcf 		ones, 4
					bsf 		status, c
					return

CARRYTENS
					bcf 		tens, 4
					bsf 		status, c
					return
;------------------ende wandlung hex nach ascii


;=============================================

;==================PAGE 1 des Speichers
				org 0x800

;----------------1 kompletter Messzyklus folgt
;----------------Messe alle Rauschspannungen und schreibe die Werte als 8BIT Ergebnis in die Register 
				;----------------bewerte rx1 bis rx8

wandlung		
			call		get_rauschspannung		
			call		rauschsperre	
			call		cor_erkennung	
			call		suche_besten_rx	
			return	
 
			






bewerte_flattern		bank1
				rlf	schieberegister1, 1
				rlf	schieberegister2, 1
				rlf	schieberegister3, 1	
				rlf	schieberegister4, 1
				rlf	schieberegister5, 1
				rlf	schieberegister6, 1
				rlf	schieberegister7, 1
				rlf	schieberegister8, 1
				rlf	schieberegister9, 1
				rlf	schieberegister10, 1
				rlf	schieberegister11, 1
				rlf	schieberegister12, 1
				rlf	schieberegister13, 1
				rlf	schieberegister14, 1
				rlf	schieberegister15, 1
				rlf	schieberegister16, 1
				rlf	schieberegister17, 1
				rlf	schieberegister18, 1	
				rlf	schieberegister19, 1
				rlf	schieberegister20, 1
				rlf	schieberegister21, 1
				rlf	schieberegister22, 1
				rlf	schieberegister23, 1
				rlf	schieberegister24, 1
				rlf	schieberegister25, 1
				rlf	schieberegister26, 1
				rlf	schieberegister27, 1
				rlf	schieberegister28, 1
				rlf	schieberegister29, 1
				rlf	schieberegister30, 1
				rlf	schieberegister31, 1
				rlf	schieberegister32, 1
				bank0
				return


;------------------hier wird geschaut, wie oft whredn der letzten 255 messungen das signal gefalttert hat: das ergebnis
;------------------steht im register: auswerteregister
auswertung_flatterautomatik	
				bank1
				clrf	auswerteregister
				movf	schieberegister1, 0
				movwf	hilfsregister1
				movf	schieberegister2, 0
				movwf	hilfsregister2
			
				movf	schieberegister3, 0
				movwf	hilfsregister3

				movf	schieberegister3, 0
				movwf	hilfsregister3

				movf	schieberegister4, 0
				movwf	hilfsregister4
				
				movf	schieberegister5, 0
				movwf	hilfsregister5
				
				movf	schieberegister6, 0
				movwf	hilfsregister6
				
				movf	schieberegister7, 0
				movwf	hilfsregister7
				
				movf	schieberegister8, 0
				movwf	hilfsregister8

				movf	schieberegister9, 0
				movwf	hilfsregister9

				movf	schieberegister10, 0
				movwf	hilfsregister10

				movf	schieberegister11, 0
				movwf	hilfsregister11

				movf	schieberegister12, 0
				movwf	hilfsregister12

				movf	schieberegister13, 0
				movwf	hilfsregister13

				movf	schieberegister14, 0
				movwf	hilfsregister14

				movf	schieberegister15, 0
				movwf	hilfsregister15

				movf	schieberegister16, 0
				movwf	hilfsregister16

				movf	schieberegister17, 0
				movwf	hilfsregister17

				movf	schieberegister18, 0
				movwf	hilfsregister18

				movf	schieberegister19, 0
				movwf	hilfsregister19

				movf	schieberegister20, 0
				movwf	hilfsregister20

				movf	schieberegister21, 0
				movwf	hilfsregister21

				movf	schieberegister22, 0
				movwf	hilfsregister22

				movf	schieberegister23, 0
				movwf	hilfsregister23

				movf	schieberegister24, 0
				movwf	hilfsregister24

				movf	schieberegister25, 0
				movwf	hilfsregister25

				movf	schieberegister26, 0
				movwf	hilfsregister26

				movf	schieberegister27, 0
				movwf	hilfsregister27

				movf	schieberegister28, 0
				movwf	hilfsregister28

				movf	schieberegister29, 0
				movwf	hilfsregister29

				movf	schieberegister30, 0
				movwf	hilfsregister30

				movf	schieberegister31, 0
				movwf	hilfsregister31

				movf	schieberegister32, 0
				movwf	hilfsregister32
			
				movlw	d'255'
				movwf	schiebezaehler

rotieren		rrf		hilfsregister32, 1
				rrf		hilfsregister31, 1
				rrf		hilfsregister30, 1
				rrf		hilfsregister29, 1		
				rrf		hilfsregister28, 1		
				rrf		hilfsregister27, 1		
				rrf		hilfsregister26, 1		
				rrf		hilfsregister25, 1		
				rrf		hilfsregister24, 1		
				rrf		hilfsregister23, 1		
				rrf		hilfsregister22, 1		
				rrf		hilfsregister21, 1		
				rrf		hilfsregister20, 1		
				rrf		hilfsregister19, 1		
				rrf		hilfsregister18, 1		
				rrf		hilfsregister17, 1		
				rrf		hilfsregister16, 1		
				rrf		hilfsregister15, 1		
				rrf		hilfsregister14, 1		
				rrf		hilfsregister13, 1		
				rrf		hilfsregister12, 1		
				rrf		hilfsregister11, 1		
				rrf		hilfsregister10, 1		
				rrf		hilfsregister9, 1		
				rrf		hilfsregister8, 1		
				rrf		hilfsregister7, 1		
				rrf		hilfsregister6, 1		
				rrf		hilfsregister5, 1		
				rrf		hilfsregister4, 1		
				rrf		hilfsregister3, 1		
				rrf		hilfsregister2, 1		
				rrf		hilfsregister1, 1	
				btfss	status, c
				goto	$+2
				incf	auswerteregister, 1
				decfsz	schiebezaehler, 1
				goto	rotieren
				bank0
				return






;bei cor_off:teste auswerteregister und schaue wie lange die nachhaltezeit der ptt ist
;im auswerteregister steht 1 fr signal ist da und 0 fr kein signal 						
;das auswerteregister beinhaltet immer die letzten 255 messwerte der rx bewertungen 
;= (ca. die letzten 1,4 sekunden des nf signals)
;die nachhaltezeit betrgt 0, 50, 100 oder 200ms je nach gte des signals
;je kleiner der wert in auswerteregister ist, umso mehr hat das signal geflattert


				;es muss nur dann geflattert werden, wenn vorher ein signal ampfangen wurde
				;ist die ptt ausgeschaltet ist dies nicht notwendig 
				;ebenso sind bei ausgeschalteter ptt die auswerteregister zu lschen
				;
sollen_wir_flattern
				
				movlw	d'253'
				subwf	auswerteregister, 0
				btfss	status, c				;ist auswerteregister kleiner 250?
				goto	$+2			;ja, es ist kleiner als 250
				goto	flatterautomatik_0ms	;nein, es ist 250 - 255

				movlw	d'250'
				subwf	auswerteregister, 0
				btfss	status, c				;ist es kleiner als 240
				goto	$+2			;ja, es ist kleiner als 240
				goto	flatterautomatik_50ms		;nein, es liegt zwischen 240 und 249

				movlw	d'247'
				subwf	auswerteregister, 0
				btfss	status, c				;ist es kleiner als 230
				goto	flatterautomatik_200ms			;ja, es ist kleiner als 230
				goto	flatterautomatik_100ms		;nein, es liegt zwischen 230 und 239

flatterautomatik_0ms		return

flatterautomatik_50ms		;schauen ob lang oder kurz geflattert werden soll
							movlw	d'1'
							subwf	ptt_tail, 0
							btfss	status, z
							goto	lang_flattern1			;ptt tail nicht1 ,also 2: lang flattern
							goto	kurz_flattern1		;ptt tail 1: also kurz flattern
							
lang_flattern1				movlw	d'20'
							movwf	flatterpause
							goto	flatterautomatik_50ms_kreisen

kurz_flattern1				movlw	d'10'
							movwf	flatterpause		

flatterautomatik_50ms_kreisen
							call	flattern_verzoegern_4ms
							call		get_rauschspannung	;dauert ca 1ms (get_rauschspannung, rauschsperre, suche_besten_rx)		
							call		rauschsperre	
							call		suche_besten_rx	
							decfsz	flatterpause, 1
							goto	flatterautomatik_50ms_kreisen	

							return

flatterautomatik_100ms		;schauen ob lang oder kurz geflattert werden soll
							movlw	d'1'
							subwf	ptt_tail, 0
							btfss	status, z
							goto	lang_flattern2			;ptt tail nicht1 ,also 2: lang flattern
							goto	kurz_flattern2		;ptt tail 1: also kurz flattern
							
lang_flattern2				movlw	d'40'
							movwf	flatterpause
							goto	flatterautomatik_100ms_kreisen

kurz_flattern2				movlw	d'20'
							movwf	flatterpause	
	
flatterautomatik_100ms_kreisen	
							call	flattern_verzoegern_4ms
							call		get_rauschspannung	;dauert ca 1ms (get_rauschspannung, rauschsperre, suche_besten_rx)		
							call		rauschsperre	
							call		suche_besten_rx	
							decfsz	flatterpause, 1
							goto	flatterautomatik_100ms_kreisen	

							return

flatterautomatik_200ms		;schauen ob lang oder kurz geflattert werden soll
							movlw	d'1'
							subwf	ptt_tail, 0
							btfss	status, z
							goto	lang_flattern3			;ptt tail nicht1 ,also 2: lang flattern
							goto	kurz_flattern3		;ptt tail 1: also kurz flattern
							
lang_flattern3				movlw	d'80'
							movwf	flatterpause
							goto	flatterautomatik_200ms_kreisen

kurz_flattern3				movlw	d'40'
							movwf	flatterpause		
flatterautomatik_200ms_kreisen	
							call	flattern_verzoegern_4ms
							call		get_rauschspannung	;dauert ca 1ms (get_rauschspannung, rauschsperre, suche_besten_rx)		
							call		rauschsperre	
							call		suche_besten_rx	
							decfsz	flatterpause, 1
							goto	flatterautomatik_200ms_kreisen	
	
							return
	



;---------------Schau nach, bei welchem RX das Empfangssignal die Rauschsperre bertrifft (RX also was hrt)
;---------------und zeig das Ergebnis in einer LED Zeile an und gib ein positives und ein negatives cor signal (ptt)
;128s
rauschsperre
sq_rx1			btfss	rx_aus_ein, 0	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx1_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx1, 0	;rx ist eingeschaltet;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx1, 0
				btfss	status, 0
				goto	rx1_sig_da		;RX hat ein Signal gehrt
				goto	rx1_sig_weg		;RX hat nix gehrt			
rx1_sig_da		bsf		squelch1_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 0	;Hilfsregister fr COR Bildung
				goto	sq_rx2
rx1_sig_weg		bcf		squelch1_led
				bcf		squelch_reg, 0
				movlw	d'255'		;rx auf ganz schlecht schalten
				movwf	rx1
				movwf	upper_limit		;keine hysterese
				movwf	lower_limit
				goto	sq_rx2

sq_rx2			btfss	rx_aus_ein, 1	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx2_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx2, 0	;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx2, 0
				btfss	status, 0
				goto	rx2_sig_da		;RX hat ein Signal gehrt
				goto	rx2_sig_weg		;RX hat nix gehrt			
rx2_sig_da		bsf		squelch2_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 1	;Hilfsregister fr COR Bildung
				goto	sq_rx3
rx2_sig_weg		bcf		squelch2_led
				bcf		squelch_reg, 1	;Hilfsregister fr COR Bildung
				movlw	d'255'
				movwf	rx2
				movwf	upper_limit
				movwf	lower_limit
				goto	sq_rx3

sq_rx3			btfss	rx_aus_ein, 2	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx3_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx3, 0	;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx3, 0
				btfss	status, 0
				goto	rx3_sig_da		;RX hat ein Signal gehrt
				goto	rx3_sig_weg		;RX hat nix gehrt			
rx3_sig_da		bsf		squelch3_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 2	;Hilfsregister fr COR Bildung
				goto	sq_rx4
rx3_sig_weg		bcf		squelch3_led
				bcf		squelch_reg, 2	;Hilfsregister fr COR Bildung
				movlw	d'255'
				movwf	rx3
				movwf	upper_limit
				movwf	lower_limit
				goto	sq_rx4

sq_rx4			btfss	rx_aus_ein, 3	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx4_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx4, 0	;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx4, 0
				btfss	status, 0
				goto	rx4_sig_da		;RX hat ein Signal gehrt
				goto	rx4_sig_weg		;RX hat nix gehrt			
rx4_sig_da		bsf		squelch4_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 3	;Hilfsregister fr COR Bildung
				goto	sq_rx5
rx4_sig_weg		bcf		squelch4_led
				bcf		squelch_reg, 3	;Hilfsregister fr COR Bildung
				movlw	d'255'
				movwf	rx4
				movwf	upper_limit
				movwf	lower_limit
				goto	sq_rx5

sq_rx5			btfss	rx_aus_ein, 4	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx5_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx5, 0	;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx5, 0
				btfss	status, 0
				goto	rx5_sig_da		;RX hat ein Signal gehrt
				goto	rx5_sig_weg		;RX hat nix gehrt			
rx5_sig_da		bsf		squelch5_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 4	;Hilfsregister fr COR Bildung
				goto	sq_rx6
rx5_sig_weg		bcf		squelch5_led
				bcf		squelch_reg, 4	;Hilfsregister fr COR Bildung
				movlw	d'255'
				movwf	rx5
				movwf	upper_limit
				movwf	lower_limit
				goto	sq_rx6

sq_rx6			btfss	rx_aus_ein, 5	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx6_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx6, 0	;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx6, 0
				btfss	status, 0
				goto	rx6_sig_da		;RX hat ein Signal gehrt
				goto	rx6_sig_weg		;RX hat nix gehrt			
rx6_sig_da		bsf		squelch6_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 5	;Hilfsregister fr COR Bildung
				goto	sq_rx7
rx6_sig_weg		bcf		squelch6_led
				bcf		squelch_reg, 5	;Hilfsregister fr COR Bildung
				movlw	d'255'
				movwf	rx6
				movwf	upper_limit
				movwf	lower_limit
				goto	sq_rx7

sq_rx7			btfss	rx_aus_ein, 6	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx7_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx7, 0	;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx7, 0
				btfss	status, 0
				goto	rx7_sig_da		;RX hat ein Signal gehrt
				goto	rx7_sig_weg		;RX hat nix gehrt			
rx7_sig_da		bsf		squelch7_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 6	;Hilfsregister fr COR Bildung
				goto	sq_rx8
rx7_sig_weg		bcf		squelch7_led
				bcf		squelch_reg, 6	;Hilfsregister fr COR Bildung
				movlw	d'255'
				movwf	rx7
				movwf	upper_limit
				movwf	lower_limit
				goto	sq_rx8

sq_rx8			btfss	rx_aus_ein, 7	;ist der rx berhaupt eingeschaltet (per software)
				goto	rx8_sig_weg		;nein, wir tun so, alsob der rx nix empfangen wrde
				movf	squelch_rx8, 0	;je grer der Wert von squelch_rx ist umso unempfindlicher ist die Rauschsperre
				addwf	rx8, 0
				btfss	status, 0
				goto	rx8_sig_da		;RX hat ein Signal gehrt
				goto	rx8_sig_weg		;RX hat nix gehrt			
rx8_sig_da		bsf		squelch8_led	;schalte passendes Lmpchen an
				bsf		squelch_reg, 7	;Hilfsregister fr COR Bildung
				goto	cor_erkennung
rx8_sig_weg		bcf		squelch8_led
				bcf		squelch_reg, 7	;Hilfsregister fr COR Bildung
				movlw	d'255'
				movwf	rx8
				movwf	upper_limit
				movwf	lower_limit
				return	
				;goto	cor_erkennung

;------------wenn im sqelch_reg alle einzelnen bits (0000 0000) auf 0 sind wurde kein signal gehrt
;------------ist mind. ein bit gesetzt so wird auch ein sig gehrt ergo ist die ptt/cor zu setzen	
;10s
cor_erkennung	movlw	0x00
				subwf	squelch_reg, 0
				btfss	status, 2		;wurde von mindestens einem rx ein sig gehrt
				goto	cor_on			;ja
				goto	cor_off			;nein
cor_on		movlw	d'0'					;ist flatterautomatik eingeschatet?
			subwf	ptt_tail, 0
			btfss	status, z			
			goto	$+2				;flatterautomatik ist ein
			goto	ist_ptt_eim	;flatterautomatik ist aus

			btfss	fast_voting, 0		;fast voten	
			goto	test_flattern1		;nein
			decfsz	fast_voten_zaehler, 1		;ja	;dann wird nur jedes 5 mal das flattern bewertet
			goto	ist_ptt_eim
			movlw	d'5'
			movwf	fast_voten_zaehler

test_flattern1
			bsf	status, c
			call	bewerte_flattern
ist_ptt_eim			btfss	ptt_positiv		;ist ptt ein
				goto	$+2				;nein, dann einschalten und vorher verzgerung prfen
				return
				;goto	t1_2			;ja, dann war ptt schon ein, wir knnen nach t1_2 gehen
				movlw	0x00	
				subwf	verzoegerung, 0	;muss verzgert werden?
				btfss	status, z				
				call	pause_verzoegern			;ja
							;nein

				bsf		ptt_positiv		;setze output port fr positive cor logik
				bcf		ptt_negativ		;lsche output port fr negative cor logik
				return
				;goto	t1_2

cor_off		movlw	d'0'					;ist flatterautomatik eingeschatet?
			subwf	ptt_tail, 0
			btfss	status, z			
			goto	$+2				;flatterautomatik ist ein
			goto	lscheoutputport	;flatterautomatik ist aus



			btfsc	ptt_positiv	;ist ptt aus
			goto	ptt_war_ein		;nein		;
			goto	ptt_war_aus		;ja


ptt_war_aus		btfss	fast_voting, 0		;fast voten	
			goto	test_flattern2		;nein
			decfsz	fast_voten_zaehler, 1		;ja	;dann wird nur jedes 5 mal das flattern bewertet
			goto	ist_ptt_aus
			movlw	d'5'
			movwf	fast_voten_zaehler

test_flattern2
				bsf	status, c				;signal fr flattern wird sukzessive auf optimal gesetzt
				call	bewerte_flattern
				
ist_ptt_aus			return



ptt_war_ein	btfss	fast_voting, 0		;fast voten	
			goto	test_flattern3		;nein
			decfsz	fast_voten_zaehler, 1		;ja	;dann wird nur jedes 5 mal das flattern bewertet
			goto	ist_ptt_aus2
			movlw	d'5'
			movwf	fast_voten_zaehler
	

test_flattern3
			bcf	status, c
			call	bewerte_flattern		;bewerten des signals
			call	auswertung_flatterautomatik	;schauen, wie gut die sigs whrend der letzten 255 messungen waren			
			call	sollen_wir_flattern		;in abhngigkeit davon ein puschen schalten	
			call	get_rauschspannung	;schauen ob signal wirlich weg ist	
			call	rauschsperre	
			call	ausbremsen_5ms		
			movlw	0x00
			subwf	squelch_reg, 0
			btfss	status, 2		;wurde von mindestens einem rx ein sig gehrt
ist_ptt_aus2
			return			;ja
			goto	lscheoutputport	;nein
			

			
lscheoutputport		bcf		ptt_positiv		;lsche output port fr positive cor logik
				bsf		ptt_negativ		;setze output port fr negative cor logik
				return
				;goto	t1_2


;----------------Entscheide welcher RX das beste Signal anliegen hat (kleinste Rauschspannung
;---------------Suche den kleinsten Wert von rx1 bis rx8 (in rx1 - rx8 liegen die Werte der AD Wandlung--------------
;50s		
suche_besten_rx
t1_2			movf		rx1, 0		;rx1 ins w register
				subwf		rx2, 0		;rx2 minus w register (rx1), ergebnis ins w register
				btfsc		status, 0	;teste auf carry flag
				goto		t1_3		;carry gesetzt, d.h. rx2 ist grer oder gleich rx1: prfe nchsten wert 
				goto		t2_3		;carry gelscht, d.h rx2 ist kleiner rx1
t1_3			movf		rx1, 0
				subwf		rx3, 0
				btfsc		status, 0
				goto		t1_4
				goto		t3_4
t1_4			movf		rx1, 0		
				subwf		rx4, 0
				btfsc		status, 0
				goto		t1_5
				goto		t4_5
t1_5			movf		rx1, 0		
				subwf		rx5, 0
				btfsc		status, 0
				goto		t1_6
				goto		t5_6
t1_6			movf		rx1, 0		
				subwf		rx6, 0
				btfsc		status, 0
				goto		t1_7
				goto		t6_7
t1_7			movf		rx1, 0		
				subwf		rx7, 0
				btfsc		status, 0
				goto		t1_8
				goto		t7_8
t1_8			movf		rx1, 0		
				subwf		rx8, 0
				btfsc		status, 0
				goto		aus1
				goto		aus8

t2_3			movf		rx2, 0
				subwf		rx3, 0
				btfsc		status, 0
				goto		t2_4
				goto		t3_4
t2_4			movf		rx2, 0
				subwf		rx4, 0
				btfsc		status, 0
				goto		t2_5
				goto		t4_5
t2_5			movf		rx2, 0		
				subwf		rx5, 0
				btfsc		status, 0
				goto		t2_6
				goto		t5_6
t2_6			movf		rx2, 0		
				subwf		rx6, 0
				btfsc		status, 0
				goto		t2_7
				goto		t6_7
t2_7			movf		rx2, 0		
				subwf		rx7, 0
				btfsc		status, 0
				goto		t2_8
				goto		t7_8
t2_8			movf		rx2, 0		
				subwf		rx8, 0
				btfsc		status, 0
				goto		aus2
				goto		aus8

t3_4			movf		rx3, 0
				subwf		rx4, 0
				btfsc		status, 0
				goto		t3_5
				goto		t4_5
t3_5			movf		rx3, 0		
				subwf		rx5, 0
				btfsc		status, 0
				goto		t3_6
				goto		t5_6
t3_6			movf		rx3, 0		
				subwf		rx6, 0
				btfsc		status, 0
				goto		t3_7
				goto		t6_7
t3_7			movf		rx3, 0		
				subwf		rx7, 0
				btfsc		status, 0
				goto		t3_8
				goto		t7_8
t3_8			movf		rx3, 0		
				subwf		rx8, 0
				btfsc		status, 0
				goto		aus3
				goto		aus8

t4_5			movf		rx4, 0		
				subwf		rx5, 0
				btfsc		status, 0
				goto		t4_6
				goto		t5_6
t4_6			movf		rx4, 0		
				subwf		rx6, 0
				btfsc		status, 0
				goto		t4_7
				goto		t6_7
t4_7			movf		rx4, 0		
				subwf		rx7, 0
				btfsc		status, 0
				goto		t4_8
				goto		t7_8
t4_8			movf		rx4, 0		
				subwf		rx8, 0
				btfsc		status, 0
				goto		aus4
				goto		aus8

t5_6			movf		rx5, 0		
				subwf		rx6, 0
				btfsc		status, 0
				goto		t5_7
				goto		t6_7
t5_7			movf		rx5, 0		
				subwf		rx7, 0
				btfsc		status, 0
				goto		t5_8
				goto		t7_8
t5_8			movf		rx5, 0		
				subwf		rx8, 0
				btfsc		status, 0
				goto		aus5
				goto		aus8

t6_7			movf		rx6, 0		
				subwf		rx7, 0
				btfsc		status, 0
				goto		t6_8
				goto		t7_8
t6_8			movf		rx6, 0		
				subwf		rx8, 0
				btfsc		status, 0
				goto		aus6
				goto		aus8

t7_8			movf		rx7, 0		
				subwf		rx8, 0
				btfsc		status, 0
				goto		aus7
				goto		aus8

;--------------nachdem jetzt bekannt ist, welcher rx der beste ist (kleinste rauschspannung) schauen wir,
;-----------ob ein neuer rx durchgeschaltet werden muss nachdem wir eine Hysterese festgelegt haben 
;60s
aus1			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 0	;ist der rx eingeschaltet (per software)
				return			;nein, dann interessiert er auch nicht weiter
				btfss		squelch_reg, 0	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
				
				
					
						
				movf		rx_alt, 0	
				addwf		hysterese_rx1, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx1, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx1, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx1			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx1, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return1					;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx1			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx1	movf		rx1, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bsf			cd4051_a 
				bsf			cd4051_b
				bsf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return1		bsf		greater_than, 0

		movf		rx2, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 1
		
		movf		rx3, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 2
		
		movf		rx4, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 3
		
		movf		rx5, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 4
		
		movf		rx6, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 5
		
		movf		rx7, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 6
		
		movf		rx8, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 7
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx1
		
		
		clrf		greater_than	
	
		return
		

	


		

aus2			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 1	;ist der rx eingeschaltet (per software)
				return						;nein, dann interessiert er auch nicht weiter
				btfss		squelch_reg, 1	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
				
				
				movf		rx_alt, 0	
				addwf		hysterese_rx2, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx2, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx2, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx2			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx2, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return2				;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx2			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx2	movf		rx2, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bcf			cd4051_a 
				bsf			cd4051_b
				bsf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return2	bsf		greater_than, 1

		movf		rx1, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 0
		
		movf		rx3, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 2
		
		movf		rx4, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 3
		
		movf		rx5, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 4
		
		movf		rx6, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 5
		
		movf		rx7, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 6
		
		movf		rx8, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 7
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx2
		
		
		clrf		greater_than	
	


	
			return
				

aus3			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 2	;ist der rx eingeschaltet (per software)
				return						;nein, dann interessiert er auch nicht weiter
			
				btfss		squelch_reg, 2	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
				
			
				movf		rx_alt, 0	
				addwf		hysterese_rx3, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx3, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx3, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx3			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx3, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return3						;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx3			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx3	movf		rx3, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bsf			cd4051_a 
				bcf			cd4051_b
				bsf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return3		bsf		greater_than, 2

		movf		rx1, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 0
		
		movf		rx2, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 1
				
		movf		rx4, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 3
		
		movf		rx5, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 4
		
		movf		rx6, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 5
		
		movf		rx7, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 6
		
		movf		rx8, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 7
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx3
		
		
		clrf		greater_than	
	


		return		
	


aus4			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 3	;ist der rx eingeschaltet (per software)
				return						;nein, dann interessiert er auch nicht weiter

				btfss		squelch_reg, 3	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
				
				
				movf		rx_alt, 0	
				addwf		hysterese_rx4, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx4, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx4, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx4			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx4, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return4						;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx4			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx4	movf		rx4, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bcf			cd4051_a 
				bcf			cd4051_b
				bsf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return4	bsf		greater_than, 3

		movf		rx1, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 0
		
		movf		rx2, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 1
		
		movf		rx3, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 2
		
		movf		rx5, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 4
		
		movf		rx6, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 5
		
		movf		rx7, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 6
		
		movf		rx8, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 7
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx4
		
		
		clrf		greater_than	
	

	
		return		
	

aus5			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 4	;ist der rx eingeschaltet (per software)
				return						;nein, dann interessiert er auch nicht weiter
				
				btfss		squelch_reg, 4	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
				
				
				movf		rx_alt, 0	
				addwf		hysterese_rx5, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx5, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx5, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx5			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx5, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return5						;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx5			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx5	movf		rx5, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bsf			cd4051_a 
				bsf			cd4051_b
				bcf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return5		bsf		greater_than, 4

		movf		rx1, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 0
		
		movf		rx2, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 1
		
		movf		rx3, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 2
		
		movf		rx4, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 3
		
		movf		rx6, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 5
		
		movf		rx7, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 6
		
		movf		rx8, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 7
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx5
		
		
		clrf		greater_than	
	



	
		return	
	
aus6			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 5	;ist der rx eingeschaltet (per software)
				return						;nein, dann interessiert er auch nicht weiter
				
				btfss		squelch_reg, 5	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
					
				
				movf		rx_alt, 0	
				addwf		hysterese_rx6, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx6, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx6, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx6			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx6, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return6						;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx6			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx6	movf		rx6, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bcf			cd4051_a 
				bsf			cd4051_b
				bcf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return6		bsf		greater_than, 5

		movf		rx1, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 0
		
		movf		rx2, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 1
		
		movf		rx3, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 2
		
		movf		rx4, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 3
		
		movf		rx5, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 4
		
		movf		rx7, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 6
		
		movf		rx8, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 7
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx6
		
		
		clrf		greater_than	
	
		return	

aus7			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 6	;ist der rx eingeschaltet (per software)
				return						;nein, dann interessiert er auch nicht weiter
			
				btfss		squelch_reg, 6	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
				
			
				movf		rx_alt, 0	
				addwf		hysterese_rx7, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx7, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx7, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx7			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx7, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return7						;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx7			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx7	movf		rx7, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bsf			cd4051_a 
				bcf			cd4051_b
				bcf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return7		bsf		greater_than, 6

		movf		rx1, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 0
		
		movf		rx2, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 1
		
		movf		rx3, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 2
		
		movf		rx4, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 3
		
		movf		rx5, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 4
		
		movf		rx6, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 5
		
		movf		rx8, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 7
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx7
		
		
		clrf		greater_than	
	


		return	
		


aus8			;festlegen des hysterese fensters: obere grenze in upper_limit, untere grenze in lower_limit
				btfss		rx_aus_ein, 7	;ist der rx eingeschaltet (per software)
				return						;nein, dann interessiert er auch nicht weiter
			
				btfss		squelch_reg, 7	;ist der squelch geffnet
				return				;nein, dann interessiert der rx nicht
				
			
				movf		rx_alt, 0	
				addwf		hysterese_rx8, 0
				movwf		upper_limit		
				btfss		status, c			;berlauf?
				goto		$+3					;nein
				movlw		d'255'				;ja: mehr als 255 geht nicht, also 255 ins register
				movwf		upper_limit
				
				movf		hystereselow_rx8, 0	
				subwf		rx_alt, 0
				movwf		lower_limit		
				btfsc		status, c			;unterlauf?
				goto		$+2					;nein
				clrf		lower_limit			;ja, weniger als 0 geht nicht, also 0 ins register
				;test, ob neues sig in diesem fenster liegt.liegt es innerhalb dieses fensters, dann tun wir nichts
				;und fangen mit einer neuen messung an. liegt es ausserhalb des fensters, dann wird ein neuer rx 
				;eingeschaltet (egal ob er besser oder schlechter ist) und der wert dieses rx wird zu rx_alt
				movf		lower_limit, 0
				subwf		rx8, 0
				btfsc		status, c
				goto		$+2					;rx1 ist gleich oder grer des lower limit, wir testen
												;ob er kleiner oder gleich upper_limit ist, denn nur dann	
												;liegt er im diskriminatorfenster und wir mssen nix tun
				goto		umschalten_rx8			;rx liegt ausserhalb des diskriminatorfensters (ist kleiner), wir schalten um
				movf		rx8, 0		
				subwf		upper_limit, 0
				btfsc		status, c
				goto		return8						;rx liegt im diskriminatorfenster, nix tun			
				goto		umschalten_rx8			;rx ist grer als upper_limit, liegt ausserhalb des diskriminatorfensters
umschalten_rx8	movf		rx8, 0
				movwf		rx_alt
				movf		portb, 0
				movwf		ausgabe		
				bcf			cd4051_a 
				bcf			cd4051_b
				bcf			cd4051_c
				movf		ausgabe, 0
				movwf		portb
				return

return8		bsf		greater_than, 7

		movf		rx1, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 0
		
		movf		rx2, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 1
		
		movf		rx3, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 2
		
		movf		rx4, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 3
		
		movf		rx5, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 4
		
		movf		rx6, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 5
		
		movf		rx7, 0
		subwf		upper_limit, 0
		btfss		status, c
		bsf		greater_than, 6
		
		movlw		b'11111111'
		subwf		greater_than, 0
		btfss		status, z
		goto		$+3		;nicht alle rxe waren greater than
		clrf		greater_than	;alle rxe wareb grer greater than	
		goto		umschalten_rx8
		
		
		clrf		greater_than	
	


	
		return
		
				

;PTT Einschaltverzgerung
pause_verzoegern	movf	verzoegerung, 0
					movwf	runterzaehlen
					call	runterzaehlpause1ms
					decfsz	runterzaehlen, 1
					goto	$-2
					return

runterzaehlpause1ms	; ****** Entry point ******     
				movlw   	0x02              ; Set up outer loop
				movwf   	timer1            ;   counter to 2
				goto		outer_loop_page1


flattern_verzoegern_4ms ; ****** Entry point ******     
				movlw   	0x08              ; Set up outer loop
				movwf   	timer1            ;   counter to 8
				goto    	outer_loop_page1        ; Go to wait loops

ausbremsen_5ms  ; ****** Entry point ******    
				movlw   	0x0a              ; Set up outer loop
				movwf   	timer1            ;   counter to 128
				goto    	outer_loop_page1        ; Go to wait loops




; Wait loops used by other wait routines
;  - 1 microsecond per instruction (with a 4 MHz microprocessor crystal)
;  - 510 instructions per inner loop
;  - (Timer1 * 514) instructions (.514 msec) per outer loop
;  - Round off to .5 ms per outer loop
;
outer_loop_page1                        
				movlw   	0xff              ; Set up inner loop counter
				movwf   	timer2            ;   to 255
inner_loop_page1
				decfsz  	timer2,f          ; Decrement inner loop counter
				goto    	inner_loop_page1        ; If inner loop counter not down to zero, 
					  ;   then go back to inner loop again
				decfsz  	timer1,f          ; Yes, Decrement outer loop counter
				goto  		outer_loop_page1        ; If outer loop counter not down to zero,
					  ;   then go back to outer loop again
				return                    ; Yes, return to caller


;---------------SUBROUTINEN
get_rauschspannung		;dauert ganz grob 800uS (genaue zeit ist auch wurscht)
				;rx1
				bank1
				movlw		b'00000000'	;oberste 8 bit der Wandlung linksbndig in register adresh
				movwf		adcon1		;8 Kanle	
				bank0
				movlw		b'01000001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx1
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				;rx2
				movlw		b'01001001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx2
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				;rx3
				movlw		b'01010001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx3
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				;rx4
				movlw		b'01011001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx4
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				;rx5
				movlw		b'01100001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx5
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				;rx6
				movlw		b'01101001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx6
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				;rx7
				movlw		b'01110001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx7
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				;rx8
				movlw		b'01111001'	;bit7,6: AD Wandler Takt; bit 6,5,4:Kanal;bit2: start; bit1: egal;bit0:ein/aus
				movwf		adcon0
				call		delay20uS	;zeit, dass sich das referenz C auf messspannung aufladen kann
				call		delay20uS
				bsf			adcon0, 2	;start messung
				btfsc		adcon0, 2	;wenn vom ad wandler auf 0 gesetzt, dann ist die wandlung fertig (ca.25uS)
				goto		$-1
				movf		adresh, 0
				movwf		rx8
				call		delay20uS	;verschnaufpause fr den AD Wandler vor der nchsten wandlung
				
				bcf			adcon0, 0	;ad wandler auschalten	
				return

;----------------delay-----
;--------------Puschen20S
delay20uS 		movlw	   	d'6'
        		movwf   	count
        		decfsz  	count,1
        		goto    	$-1
        		return

;==============================
;==================================

;==============================
;==================================
;==================PAGE 2 des Speichers
				org 0x1000

;==============================


;----------eepromroutinen
;-----------eepromweerte fr squelch und hysterese auslesen
eeprom_auslesen	
				
				movlw		0x00		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx1
				
				movlw		0x01		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx2
				
				movlw		0x02		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx3
				
				movlw		0x03		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx4
				
				movlw		0x04		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx5
				
				movlw		0x05		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx6
				
				movlw		0x06		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx7
				
				movlw		0x07		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		squelch_rx8

				movlw		0x08		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx1

				movlw		0x09		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx2

				movlw		0x0a		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx3

				movlw		0x0b		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx4

				movlw		0x0c		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx5

				movlw		0x0d		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx6

				movlw		0x0e		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx7

				movlw		0x0f		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hysterese_rx8
				
				movlw		0x10		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		rx_aus_ein
								
				movlw		0x11		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx1

				movlw		0x12		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx2

				movlw		0x13		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx3

				movlw		0x14		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx4

				movlw		0x15		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx5

				movlw		0x16		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx6

				movlw		0x17		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx7

				movlw		0x18		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		hystereselow_rx8

				movlw		0x19		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		fast_voting

				movlw		0x1a		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		verzoegerung

				movlw		0x1b		;adresse des eeprom bytes
				movwf		adresse
				call		eepromread	;ergebnis des auslesens in w
				movwf		ptt_tail

				return

			
;-----------ende eepromweerte fr squelch und hysterese auslesen


;----------1 byte aus dem eeprom auslesen
eepromread		movf		adresse, 0
				bsf			status, rp1
				bcf			status, rp0
				movwf		eeadr
				bsf			status, rp0
				bcf			eecon1, eepgd		
				bsf			eecon1, rd	
				bcf			status, rp0
				movf		eedata, 0
				bcf			status, rp0
				bcf			status, rp1
				return
;------------------Ende EEPROM auslesen

;------------------squelch_rx und hysterese_rx werte ins eeprom schreiben
eeprom_beschreiben

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x00
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx1, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x01
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx2, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x02
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx3, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x03
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx4, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x04
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx5, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x05
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx6, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x06
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx7, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x07
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		squelch_rx8, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x08
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx1, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x09
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx2, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x0a
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx3, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x0b
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx4, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x0c
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx5, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x0d
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx6, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x0e
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx7, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x0f
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hysterese_rx8, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
				
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x10
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		rx_aus_ein, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x11
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx1, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x12
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx2, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x13
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx3, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x14
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx4, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x15
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx5, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x16
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx6, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x17
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx7, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x18
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		hystereselow_rx8, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite
			
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x19
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		fast_voting, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x1a
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		verzoegerung, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bsf			status, rp1
				bcf			status, rp0	;bank2
				movlw		0x1b
				movwf		eeadr
				bcf			status, rp0
				bcf			status, rp1	;bank0
				movf		ptt_tail, 0
				bsf			status, rp1
				bcf			status, rp0	;bank2
				movwf		eedata
				call		eepromwrite

				bank0
				return
;-------------------ende werte ins eeprom schreiben

;--------------------------1 byte im EEPROM beschreiben
eepromwrite				;bsf			status, rp0
				;bsf			status, rp1	;bank3
				
				bank3
				bcf			eecon1, eepgd
				bsf			eecon1, wren
				bcf			intcon, 7		;verbiete interrupts grundstzlich 
				movlw		0x55
				movwf		eecon2
				movlw		0xaa
				movwf		eecon2
				bsf			eecon1, wr
				btfsc		eecon1, wr
				goto		$-1
				bcf			eecon1, wren
				;bsf			intcon, 7		;erlaube interrupts wieder (die, die auch vorher erlaubt waren (nur tmr0 overflow))

				return
;-------------------ENDE EEPROM beschreiben





;==================================
;==================PAGE 3 des Speichers
				org 0x1800
;==================PAUSEN======================
; *****************************************************************************
; *                                                                           *
; * Purpose:  Wait for a specified number of milliseconds.                    *
; *                                                                           *
; *           Entry point wait_128ms:  Wait for 128 msec                      *
; *           Entry point wait_64ms :  Wait for 64 msec                       *
; *           Entry point wait_32ms :  Wait for 32 msec                       *
; *           Entry point wait_16ms :  Wait for 16 msec                       *
; *           Entry point wait_8ms  :  Wait for 8 msec                        *
; *                                                                           *
; *   Input:  None                                                            *
; *                                                                           *
; *  Output:  None                                                            *
; *                                                                           *
; *****************************************************************************
;
wait_128ms_3  ; ****** Entry point ******    
				movlw	  	0xff              ; Set up outer loop 
				movwf  	 	timer1            ;   counter to 255
				goto   	 	outer_loop3        ; Go to wait loops
wait_64ms_3  ; ****** Entry point ******     
				movlw   	0x80              ; Set up outer loop
				movwf   	timer1            ;   counter to 128
				goto    	outer_loop3        ; Go to wait loops
wait_32ms_3   ; ****** Entry point ******    
				movlw   	0x40              ; Set up outer loop
				movwf   	timer1            ;   counter to 64
				goto    	outer_loop3        ; Go to wait loops
wait_16ms_3   ; ****** Entry point ******    
				movlw   	0x20              ; Set up outer loop
				movwf   	timer1            ;   counter to 32  
				goto    	outer_loop3        ; Go to wait loops
wait_8ms_3   ; ****** Entry point ******     
				movlw   	0x10              ; Set up outer loop
				movwf   	timer1            ;   counter to 16
				goto 		outer_loop3	  ; Fall through into wait loops
wait_1ms_3   ; ****** Entry point ******     
				movlw   	0x02              ; Set up outer loop
				movwf   	timer1            ;   counter to 2
				goto		outer_loop3


		
; Wait loops used by other wait routines
;  - 1 microsecond per instruction (with a 4 MHz microprocessor crystal)
;  - 510 instructions per inner loop
;  - (Timer1 * 514) instructions (.514 msec) per outer loop
;  - Round off to .5 ms per outer loop
;
outer_loop3                        
				movlw   	0xff              ; Set up inner loop counter
				movwf   	timer2            ;   to 255
inner_loop3
				decfsz  	timer2,f          ; Decrement inner loop counter
				goto    	inner_loop3        ; If inner loop counter not down to zero, 
					  ;   then go back to inner loop again
				decfsz  	timer1,f          ; Yes, Decrement outer loop counter
				goto  		outer_loop3        ; If outer loop counter not down to zero,
					  ;   then go back to outer loop again
				return                    ; Yes, return to caller
;--------------ende pausen





;-------------------LCD Routinen
;so wird an den lcd gecshrieben		;movlw	b'11000000'	;zeile 2		b'10000000':zeile 1
									;call	cmnd2LCD
									;movlw	'1'			;datenausgaben
									;call	data2LCD
;-------------------------------Initialisierung der LCD Anzeige
init_lcd_page3		
				call    	wait_16ms_3         ; Wait for LCD to power up
				
				movlw   	b'00110000'              ; LCD init instruction (First)
				movwf   	portd             ; Send to LCD via RB7..RB0
				bsf     	lcd_e       ; Set the LCD E line high,
				
				call    	wait_16ms_3         ;   wait a "long" time,
				
				bcf     	lcd_e       ;   and then Clear E 
				movlw   	b'00110000'              ; LCD init instruction (Second)
				movwf   	portd             ; Send to LCD via RB7..RB0
				bsf     	lcd_e       ; Set E high,
				
				call    	wait_16ms_3         ;   wait a while,
				
				bcf     	lcd_e       ;   and then Clear E 
				movlw   	b'00110000'              ; LCD init instruction (Third)
				movwf   	portd             ; Send to LCD via RB7..RB0
				bsf     	lcd_e       ; Set E high,
				
				call    	wait_16ms_3         ;   wait a while,
				
				bcf     	lcd_e       ;   and then Clear E
				movlw   	b'00101000'              ; 4-bit mode instruction, 2 lines, 5*7 dot matrix
				call		cmnd2LCD	    ;Send command to LCD
				movlw   	b'00001000'              ; Display off, cursor and blink off 
				call    	cmnd2LCD          ; Send command to LCD
				movlw   	b'00000001'              ; Clear and reset cursor
				call    	cmnd2LCD          ; Send command in w to LCD
				movlw   	b'00000110'              ; Set cursor to move right, no shift
				call    	cmnd2LCD          ; Send command in w to LCD
				movlw   	b'00001100'              ; Display on, cursor and blink off
				call    	cmnd2LCD          ; Send command in w to LCD
				return                    ; 

;*****************************************************************************
; * Purpose:  Send Command or Data byte to the LCD                            *
; *           Entry point cmnd2LCD:  Send a Command to the LCD                *
; *           Entry Point data2LCD:  Send a Data byte to the LCD              *
; *                                                                           *
; *   Input:  W has the command or data byte to be sent to the LCD.           *
; *                                                                           *
; *  Output:  None                                                            *
; *****************************************************************************
;1 byte schreiben dauert: 33s + ca 150s fr busy_check (ca200s pro byte insgesamt)
cmnd2LCD   ; ****** Entry point ******
				movwf   	lcd_char          ; Save byte to write to LCD
				clrf    	rs_value          ; Remember to clear RS  (clear rs_value)   
				bcf     	lcd_rs      ; Set RS for Command to LCD
				goto    	write2LCD         ; Go to common code
data2LCD   ; ****** Entry point ********
				movwf   	lcd_char          ; Save byte to write to LCD
				bsf     	rs_value,0        ; Remember to set RS (set bit 0 of rs_value)
				bsf     	lcd_rs      ; Set RS for Data to LCD
write2LCD
				call    	busy_check        ; Check to see if LCD is ready for new data
				;clrf    	portd             ; Clear all of Port B (inputs and outputs)
				movlw	b'00000001'		;port d lschen bis auf bit 0: dieses nicht ndern
				andwf	portd, 1
				bank1      ; Switch to bank 1 for Tristate operation
				movlw   	b'00000000'              ; Set up to enable portb data pins
				movwf   	trisd             ; All pins (RD7..RD0) are back to outputs
				bank0      ; Switch to bank 0
				bcf     	lcd_rw      ; Set LCD back to Write mode  (RW = 0)
				bcf     	lcd_rs      ; Guess RS should be clear              
				btfsc   	rs_value,0        ; Should RS be clear?  (is bit 0 == 0?) 
				bsf     	lcd_rs      ; No, set RS                            
;
; Transfer Most Significant nibble  (XXXX portion of XXXXYYYY)
;
				movlw   	0x0F              ; Set up mask                                 
				andwf   	portd,f           ; Clear old RB7..RB4 
				movf    	lcd_char,w        ; Put byte of data into W
				andlw   	0xF0              ; Mask to give XXXX0000 in W
				iorwf   	portd,f           ; Send to RB7..RB4 without changing RB3..RB0
				bsf     	lcd_e       ; Pulse the E line high,
				nop            	           ;   wait, 
				bcf     	lcd_e       ;   and drop it again
;
; Transfer Least Significant nibble  (YYYY portion of XXXXYYYY)
;
				movlw  	0x0F              ; Set up mask                                 
				andwf   	portd,f           ; Clear old RB7..RB4
				swapf   	lcd_char,w        ; Move LS nibble of data to MS position in W
				andlw   	0xF0              ; Mask to give YYYY0000 in W
				iorwf   	portd,f           ; Send to RB7..RB4 without changing RB3..RB0
				bsf     	lcd_e       ; Pulse the E line high,
				nop          		             ;   wait, 
				bcf     	lcd_e       ;   and drop it again
				return
;
; *****************************************************************************
; *                                                                           *
; * Purpose:  Check if LCD is done with the last operation.                   *
; *           This subroutine polls the LCD busy flag to determine if         *
; *           previous operations are completed.                              *
; *                                                                           *
; *   Input:  None                                                            *
; *                                                                           *
; *  Output:  PortB set as:  RB7..RB4 inputs                                  *
; *                          RB3..RB0 outputs                                 *
; *****************************************************************************
; 
busy_check				
				;clrf    	portd             ; Clear all outputs on PortB
				movlw	b'00000001'		;portd lschen, bit 0 nicht ndern da ptt		
				andwf	portd, 1
				bank1      ; Switch to bank 1 for Tristate operation
				movlw   	b'11110000'       ; Set RD7..RD4 as inputs, RB3..RB0 outputs
				movwf   	trisd             ;   via Tristate
				bank0      ; Switch back to bank 0
				bcf     	lcd_rs      ; Set up LCD for Read Busy Flag (RS = 0) 
				bsf     	lcd_rw      ; Set up LCD for Read (RW = 1)  
				movlw   	0xff              ; Set up constant 255	
				movwf   	timer3            ;   for timer loop counter
LCD_is_busy
				bsf     	lcd_e       ; Set E high
				movf    	portd, w           ; Read PortB into W
				movwf   	lcd_read          ; Save W for later testing
				bcf     	lcd_e       ; Drop E again
				nop                       		; Wait a
				nop            	           ;   while
				bsf     	lcd_e       ; Pulse E high (dummy read of lower nibble),
				nop            	           ;   wait,
				bcf     	lcd_e       ;   and drop E again
				decf    	timer3,f          ; Decrement loop counter	
				btfsc   	status, z        ; Is loop counter down to zero?
				goto    	not_busy          ; If yes, return regardless
				btfsc   	lcd_read,7        ; Is Busy Flag (RB7) in save byte clear?
				goto    	LCD_is_busy       ; If not, it is busy so jump back
not_busy
				return                    ; 
		
;----------ende lcd routinen
;---------ausgaben an lcd


menue_lcd_page3		movlw	b'00000001'	;clear display
				call	cmnd2LCD

			movlw	b'11000000'
				call	cmnd2LCD
				movlw	'M'
				call	data2LCD
				movlw	'E'
				call	data2LCD
				movlw	'N'
				call	data2LCD
				movlw	'U'
				call	data2LCD
				movlw	'E'
				call	data2LCD
				return	
ausgabe_rx1_page3
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'1'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_rx2_page3
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'2'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_rx3_page3	
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'3'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_rx4_page3	
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'4'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_rx5_page3	
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'5'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_rx6_page3	
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'6'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_rx7_page3	
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'7'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_rx8_page3	
				call	squelch_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'8'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return

ausgabe_hys_rx1_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'1'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_hys_rx2_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'2'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_hys_rx3_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'3'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_hys_rx4_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'4'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_hys_rx5_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'5'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_hys_rx6_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'6'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_hys_rx7_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'7'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
ausgabe_hys_rx8_page3
				call	hysterese_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'8'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return

ausgabe_hyslow_rx1_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'1'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return


ausgabe_hyslow_rx2_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'2'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return


ausgabe_hyslow_rx3_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'3'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return


ausgabe_hyslow_rx4_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'4'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return


ausgabe_hyslow_rx5_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'5'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return
		

ausgabe_hyslow_rx6_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'6'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return


ausgabe_hyslow_rx7_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'7'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return


ausgabe_hyslow_rx8_page3
				call	hystereselow_page3
				movlw	b'10001010'	
				call	cmnd2LCD								
				movlw	'0'
				call	data2LCD
				movlw	'8'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				return




ausgabe_rx_aus_ein_rx1_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'1'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 0	
				goto	off_rx1
				goto	on_rx1
off_rx1				call	off_page3
				return								
on_rx1				call	on_page3
				return

ausgabe_rx_aus_ein_rx2_page3	
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'2'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 1	
				goto	off_rx2
				goto	on_rx2
off_rx2				call	off_page3
				return								
on_rx2				call	on_page3
				return

ausgabe_rx_aus_ein_rx3_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'3'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 2	
				goto	off_rx3
				goto	on_rx3
off_rx3				call	off_page3
				return								
on_rx3				call	on_page3
				return

ausgabe_rx_aus_ein_rx4_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'4'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 3	
				goto	off_rx4
				goto	on_rx4
off_rx4				call	off_page3
				return								
on_rx4				call	on_page3
				return

ausgabe_rx_aus_ein_rx5_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'5'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 4	
				goto	off_rx5
				goto	on_rx5
off_rx5				call	off_page3
				return								
on_rx5				call	on_page3
				return

ausgabe_rx_aus_ein_rx6_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'6'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 5	
				goto	off_rx6
				goto	on_rx6
off_rx6				call	off_page3
				return								
on_rx6				call	on_page3
				return

ausgabe_rx_aus_ein_rx7_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'7'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 6	
				goto	off_rx7
				goto	on_rx7
off_rx7				call	off_page3
				return								
on_rx7				call	on_page3
				return

ausgabe_rx_aus_ein_rx8_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'8'
				call	data2LCD
				movlw	':'
				call	data2LCD
				btfss	rx_aus_ein, 7	
				goto	off_rx8
				goto	on_rx8
off_rx8				call	off_page3
				return								
on_rx8				call	on_page3
				return



off_page3				movlw	b'10000110'
				call	cmnd2LCD
				movlw	' '
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	'f'
				call	data2LCD
				movlw	'f'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				return

on_page3				movlw	b'10000110'
				call	cmnd2LCD
				movlw	' '
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	'n'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				return


squelch_page3	call	menu_2zeile
				movlw	b'10000000'
				call	cmnd2LCD
				movlw	'S'
				call	data2LCD
				movlw	'q'
				call	data2LCD
				movlw	'u'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'l'
				call	data2LCD
				movlw	'c'
				call	data2LCD
				movlw	'h'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				return

hysterese_page3	
				call	up_limit
				movlw	b'10000000'
				call	cmnd2LCD
				movlw	'H'
				call	data2LCD
				movlw	'y'
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	'.'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				return

hystereselow_page3	
				call	lo_limit
				movlw	b'10000000'
				call	cmnd2LCD
				movlw	'H'
				call	data2LCD
				movlw	'y'
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	'.'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				return


menue_ende_page3	
				movlw	b'00000001'	;clear display
				call	cmnd2LCD
				movlw	b'10000000'
				call	cmnd2LCD	
				movlw	's'
				call	data2LCD
				movlw	'a'
				call	data2LCD
				movlw	'v'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				
				return
lcd_gru_page3
				movlw	b'00000001'	;clear display
				call	cmnd2LCD
				movlw	b'10000000'
				call	cmnd2LCD	
				movlw	'R'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'c'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'i'
				call	data2LCD
				movlw	'v'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'V'
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				
				movlw	b'11000000'
				call	cmnd2LCD	
				movlw	'D'
				call	data2LCD
				movlw	'L'
				call	data2LCD
				movlw	'5'
				call	data2LCD
				movlw	'M'
				call	data2LCD
				movlw	'G'
				call	data2LCD
				movlw	'D'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'V'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	'.'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'1'
				call	data2LCD
				movlw	'.'
				call	data2LCD
				movlw	'4'
				call	data2LCD
				return	


ausgabe_fast_voting_page3		
				call	menu_2zeile
				movlw	b'10000000'		
				call	cmnd2LCD
				movlw	'f'
				call	data2LCD
				movlw	'a'
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'v'
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	'i'
				call	data2LCD
				movlw	'n'
				call	data2LCD
				movlw	'g'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movlw	' '
				call	data2LCD
				btfss	fast_voting, 0	
				goto	off_fast_voting
				goto	on_fast_voting
off_fast_voting	movlw	'o'
				call	data2LCD
				movlw	'f'
				call	data2LCD
				movlw	'f'
				call	data2LCD
				return								
on_fast_voting	movlw	'o'
				call	data2LCD
				movlw	'n'
				call	data2LCD
				movlw	' '
				call	data2LCD
				return




lcd_normalbetrieb_page3
				movlw	b'00000001'	;clear display
				call	cmnd2LCD
				movlw	b'10000000'
				call	cmnd2LCD	
				movlw	'f'
				call	data2LCD
				movlw	'a'
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'v'
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	'i'
				call	data2LCD
				movlw	'n'
				call	data2LCD
				movlw	'g'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'R'
				call	data2LCD
				movlw	'X'
				call	data2LCD
				movlw	':'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				
				movlw	b'11000000'
				call	cmnd2LCD	
				
				btfss	rx_aus_ein, 0	
				goto	$+5
				movlw	'1'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				btfss	rx_aus_ein, 1	
				goto	$+5
				movlw	'2'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				btfss	rx_aus_ein, 2	
				goto	$+5
				movlw	'3'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				btfss	rx_aus_ein, 3	
				goto	$+5
				movlw	'4'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				btfss	rx_aus_ein, 4	
				goto	$+5
				movlw	'5'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				btfss	rx_aus_ein, 5	
				goto	$+5
				movlw	'6'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				btfss	rx_aus_ein, 6	
				goto	$+5
				movlw	'7'
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				btfss	rx_aus_ein, 7	
				goto	$+3
				movlw	'8'
				call	data2LCD
				
				return	

menu_2zeile		movlw	b'11000000'
				call	cmnd2LCD	
				movlw	'M'
				call	data2LCD
				movlw	'E'
				call	data2LCD
				movlw	'N'
				call	data2LCD
				movlw	'U'
				call	data2LCD
				movlw	'E'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				return

up_limit		movlw	b'11000000'
				call	cmnd2LCD	
				movlw	't'
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'w'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'a'
				call	data2LCD
				movlw	'k'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	'i'
				call	data2LCD
				movlw	'g'
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				return

lo_limit		movlw	b'11000000'
				call	cmnd2LCD	
				movlw	't'
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	'n'
				call	data2LCD
				movlw	'g'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	'i'
				call	data2LCD
				movlw	'g'
				call	data2LCD
				movlw	's'
				call	data2LCD
				
				return


				



spannung_lcd	movlw	b'10000000'	
				call	cmnd2LCD
				comf	rx1, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				btfss	rx_aus_ein, 0
				goto	rx_njet0		;rx_aus
				btfss	squelch_reg, 0				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet0		call	rx_njet

				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
				comf	rx2, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				;btfss	rx_aus_ein, 1
				;call	rx_njet			;rx aus
										;rx ein
				btfss	rx_aus_ein, 1
				goto	rx_njet1		;rx_aus
				btfss	squelch_reg, 1				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet1		call	rx_njet				

				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD	
				comf	rx3, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
			;	btfss	rx_aus_ein, 2
			;	call	rx_njet			;rx aus
										;rx ein
			
				btfss	rx_aus_ein, 2
				goto	rx_njet2		;rx_aus
				btfss	squelch_reg, 2				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet2		call	rx_njet				
	
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
				comf	rx4, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
		;		btfss	rx_aus_ein, 3
		;		call	rx_njet			;rx aus
										;rx ein
		
				btfss	rx_aus_ein, 3
				goto	rx_njet3		;rx_aus
				btfss	squelch_reg, 3				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet3		call	rx_njet				

		
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
			
				movlw	b'11000000'
				call	cmnd2LCD
				
				comf	rx5, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				;btfss	rx_aus_ein, 4
				;call	rx_njet			;rx aus
										;rx ein
				
				btfss	rx_aus_ein, 4
				goto	rx_njet4		;rx_aus
				btfss	squelch_reg, 4				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet4		call	rx_njet				


				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD	
				comf	rx6, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				;btfss	rx_aus_ein, 5
				;call	rx_njet			;rx aus
										;rx ein
			
				btfss	rx_aus_ein, 5
				goto	rx_njet5		;rx_aus
				btfss	squelch_reg, 5				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet5		call	rx_njet				

	
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
				comf	rx7, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
		;		btfss	rx_aus_ein, 6
		;		call	rx_njet			;rx aus
										;rx ein
		
				btfss	rx_aus_ein, 6
				goto	rx_njet6		;rx_aus
				btfss	squelch_reg, 6				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet6		call	rx_njet				

		
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
				comf	rx8, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
		;		btfss	rx_aus_ein, 7
		;		call	rx_njet			;rx aus
										;rx ein
		
				btfss	rx_aus_ein, 7
				goto	rx_njet7		;rx_aus
				btfss	squelch_reg, 7				;rx ein
				call	gesquelcht				;rx gesquelcht	
				goto	$+2				;rx nicht gesquelcht				
rx_njet7		call	rx_njet				

		
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
			
				return


rx_njet			movlw	'o'				
				movwf	huns
				movlw	'f'
				movwf	tens
				movwf	'f'
				movwf	ones
				return
		
gesquelcht		movlw	's'				
				movwf	huns
				movlw	'q'
				movwf	tens
				movlw	'u'
				movwf	ones
				return
		

ausgabe_ptt_verzoegerung_page3
				
				movlw	b'10000000'
				call	cmnd2LCD	
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'm'
				call	data2LCD
				movlw	'S'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'P'
				call	data2LCD
				movlw	'T'
				call	data2LCD
				movlw	'T'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'('
				call	data2LCD
				movlw	'C'
				call	data2LCD
				movlw	'O'
				call	data2LCD
				movlw	'R'
				call	data2LCD
				movlw	')'
				call	data2LCD
				

				movlw	b'11000000'
				call	cmnd2LCD	
				movlw	't'
				call	data2LCD
				movlw	'u'
				call	data2LCD
				movlw	'r'
				call	data2LCD
				movlw	'n'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'o'
				call	data2LCD
				movlw	'n'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'd'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	'l'
				call	data2LCD
				movlw	'a'
				call	data2LCD
				movlw	'y'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				
				return

		
				
				
;subroutine zum testen (keine invertierten rx spannungen und hysterese level				
spannung_lcd_test	movlw	b'10000000'	
				call	cmnd2LCD
				movf	rx1, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			;	movlw	' '
			;	call	data2LCD
				movf	rx2, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			;	movlw	' '
			;	call	data2LCD	
				movf	rx3, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			;	movlw	' '
			;	call	data2LCD
				movf	rx4, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
			
				movf	upper_limit, 0
				movwf	binaer	
				page0	
				call	bin2ascii
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			
				movlw	b'11000000'
				call	cmnd2LCD
				
				movf	rx5, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			;	movlw	' '
			;	call	data2LCD	
				movf	rx6, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			;	movlw	' '
			;	call	data2LCD
				movf	rx7, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			;	movlw	' '
			;	call	data2LCD
				movf	rx8, 0
				movwf	binaer
				page0	
				call	bin2ascii				
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
				movlw	' '
				call	data2LCD
			
				movf	lower_limit, 0
				movwf	binaer	
				page0	
				call	bin2ascii
				page3
				movf	huns, 0
				call	data2LCD
				movf	tens, 0
				call	data2LCD
				movf	ones, 0
				call	data2LCD
			
				return


ausgabe_reset_page3		movlw	b'00000001'	;clear display
				call	cmnd2LCD
				movlw	b'10000000'
				call	cmnd2LCD	
				movlw	'r'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	's'
				call	data2LCD
				movlw	'e'
				call	data2LCD
				movlw	't'
				call	data2LCD
				return



ausgabe_ptt_tail_zeile1_page3
				
				movlw	b'10000000'
				call	cmnd2LCD
				movlw	'P'
				call	data2LCD
				movlw	'T'
				call	data2LCD
				movlw	'T'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'('
				call	data2LCD
				movlw	'C'
				call	data2LCD
				movlw	'O'
				call	data2LCD
				movlw	'R'
				call	data2LCD
				movlw	')'
				call	data2LCD				
				movlw	' '
				call	data2LCD
				movlw	't'
				call	data2LCD
				movlw	'a'
				call	data2LCD
				movlw	'i'
				call	data2LCD
				movlw	'l'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				return

ausgabe_ptt_tail0_page3
				movlw	b'11000000'
				call	cmnd2LCD
				movlw	'o'
				call	data2LCD
				movlw	'f'
				call	data2LCD
				movlw	'f'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD				
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	' '
				call	data2LCD
				return
				
ausgabe_ptt_tail50_page3
				movlw	b'11000000'
				call	cmnd2LCD
				movlw	'0'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'5'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'1'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	' '
				call	data2LCD				
				movlw	'2'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'm'
				call	data2LCD
				movlw	'S'
				call	data2LCD
				movlw	' '
				call	data2LCD
				return

ausgabe_ptt_tail100_page3
				movlw	b'11000000'
				call	cmnd2LCD
				movlw	'0'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'1'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'2'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'0'
				call	data2LCD				
				movlw	' '
				call	data2LCD
				movlw	'4'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	'0'
				call	data2LCD
				movlw	' '
				call	data2LCD
				movlw	'm'
				call	data2LCD
				movlw	'S'
				call	data2LCD
				return



				end
